/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import nu.fw.jeti.backend.roster.JIDStatusTree;
import nu.fw.jeti.backend.roster.NormalJIDStatus;
import nu.fw.jeti.backend.roster.PrimaryJIDStatus;
import nu.fw.jeti.events.JavaErrorListener;
import nu.fw.jeti.events.RegisterListener;
import nu.fw.jeti.events.ServerListener;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.elements.IQLast;
import nu.fw.jeti.jabber.elements.IQRegister;
import nu.fw.jeti.jabber.elements.IQTime;
import nu.fw.jeti.jabber.elements.IQVersion;
import nu.fw.jeti.jabber.elements.IQXRoster;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.jabber.elements.RosterItem;
import nu.fw.jeti.ui.Jeti;
import nu.fw.jeti.ui.RegisterWindow;
import nu.fw.jeti.ui.SendMessage;
import nu.fw.jeti.ui.models.RosterTreeModel;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class ServerTree
extends JTree
implements JavaErrorListener,
RegisterListener {
    private Backend backend;
    private JPopupMenu popupMenu;
    private JIDStatus currentJIDStatus;
    private JID registerJID;
    private Jeti main;

    public ServerTree(Backend backend, Jeti jeti) {
        super(new RosterTreeModel());
        this.backend = backend;
        backend.addListener(ServerListener.class, (RosterTreeModel)this.getModel());
        backend.addListener(JavaErrorListener.class, this);
        this.main = jeti;
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setRootVisible(false);
        this.putClientProperty("JTree.lineStyle", "None");
        this.setToggleClickCount(1);
        BasicTreeUI basicTreeUI = (BasicTreeUI)this.getUI();
        basicTreeUI.setRightChildIndent(1);
        basicTreeUI.setLeftChildIndent(1);
        basicTreeUI.setExpandedIcon(null);
        basicTreeUI.setCollapsedIcon(null);
        this.createPopupMenu();
        this.setCellRenderer(new MyRenderer());
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                TreePath treePath = ServerTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null) {
                    ServerTree.this.setSelectionPath(treePath);
                    Object object = treePath.getLastPathComponent();
                    if (object instanceof PrimaryJIDStatus) {
                        ServerTree.this.maybeShowPopup(mouseEvent, ((PrimaryJIDStatus)object).getJIDPrimaryStatus());
                        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 1) {
                            ServerTree.this.sendChat(((PrimaryJIDStatus)object).getJIDPrimaryStatus());
                        }
                    }
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                Object object;
                TreePath treePath = ServerTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof PrimaryJIDStatus) {
                    ServerTree.this.maybeShowPopup(mouseEvent, ((PrimaryJIDStatus)object).getJIDPrimaryStatus());
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                ServerTree.this.clearSelection();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                Object object;
                TreePath treePath = ServerTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof PrimaryJIDStatus) {
                    ServerTree.this.setSelectionPath(treePath);
                }
            }
        });
    }

    private void createPopupMenu() {
        this.popupMenu = new JPopupMenu();
        JMenuItem jMenuItem = null;
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic("main.main.rostermenu.Message", jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerTree.this.sendMessage(ServerTree.this.currentJIDStatus);
            }
        });
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic("main.main.rostermenu.Chat", jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerTree.this.sendChat(ServerTree.this.currentJIDStatus);
            }
        });
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic("main.main.rostermenu.Log_On", jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((NormalJIDStatus)ServerTree.this.currentJIDStatus).setForcedOffline(false);
                ServerTree.this.backend.send(new Presence(ServerTree.this.currentJIDStatus.getJID(), "available"));
            }
        });
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic("main.main.rostermenu.Log_Off", jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((NormalJIDStatus)ServerTree.this.currentJIDStatus).setForcedOffline(true);
                ServerTree.this.backend.send(new Presence(ServerTree.this.currentJIDStatus.getJID(), "unavailable"));
            }
        });
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(I18N.gettext("main.main.rostermenu.Remove") + "...");
        I18N.setMnemonic("main.main.rostermenu.Remove", jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JID jID = ServerTree.this.currentJIDStatus.getJID();
                if (JOptionPane.showConfirmDialog(ServerTree.this.main, MessageFormat.format(I18N.gettext("main.popup.Really_remove_{0}_from_all_groups_?"), jID.toString()), I18N.gettext("Remove"), 0) == 0) {
                    IQXRoster iQXRoster = new IQXRoster(new RosterItem(jID, null, "remove", null, null));
                    ServerTree.this.backend.send(new InfoQuery("set", iQXRoster));
                }
            }
        });
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(I18N.gettext("main.main.rostermenu.Rename") + "...");
        I18N.setMnemonic("main.main.rostermenu.Rename", jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(ServerTree.this.main, (Object)MessageFormat.format(I18N.gettext("main.popup.Rename_{0}_to"), ServerTree.this.currentJIDStatus.getNick()));
                if (string == null) {
                    return;
                }
                IQXRoster iQXRoster = new IQXRoster(new RosterItem(ServerTree.this.currentJIDStatus.getJID(), string, null, null, ServerTree.this.currentJIDStatus.getGroupsCopy()));
                ServerTree.this.backend.send(new InfoQuery("set", iQXRoster));
            }
        });
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic("main.main.rostermenu.Local_Time", jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerTree.this.backend.send(new InfoQuery(ServerTree.this.currentJIDStatus.getCompleteJID(), "get", new IQTime()));
            }
        });
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic("main.main.rostermenu.Last_Seen", jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerTree.this.backend.send(new InfoQuery(ServerTree.this.currentJIDStatus.getCompleteJID(), "get", new IQLast()));
            }
        });
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic("main.main.rostermenu.Local_Version", jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerTree.this.backend.send(new InfoQuery(ServerTree.this.currentJIDStatus.getCompleteJID(), "get", new IQVersion()));
            }
        });
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic("main.main.rostermenu.Invisible", jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerTree.this.backend.send(new Presence(ServerTree.this.currentJIDStatus.getJID(), "invisible"));
            }
        });
        this.popupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(I18N.gettext("main.main.rostermenu.Edit_Registration"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerTree.this.backend.addListener(class$nu$fw$jeti$events$RegisterListener == null ? (class$nu$fw$jeti$events$RegisterListener = ServerTree.class$("nu.fw.jeti.events.RegisterListener")) : class$nu$fw$jeti$events$RegisterListener, ServerTree.this);
                ServerTree.this.registerJID = ServerTree.this.currentJIDStatus.getJID();
                ServerTree.this.backend.send(new InfoQuery(ServerTree.this.registerJID, "get", ServerTree.this.backend.getIdentifier(), new IQRegister()));
            }
        });
        this.popupMenu.add(jMenuItem);
    }

    public void updateLF() {
        SwingUtilities.updateComponentTreeUI(this.popupMenu);
    }

    public void clearError() {
        ((RosterTreeModel)this.getModel()).remove();
    }

    public void error() {
        if (Preferences.getBoolean("jeti", "jetimenuShowLog", true) && Preferences.getBoolean("jeti", "jetiShowError", true)) {
            ((RosterTreeModel)this.getModel()).add();
        }
    }

    public void openGroups() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JIDStatusTree jIDStatusTree = (JIDStatusTree)ServerTree.this.getModel().getRoot();
                TreePath treePath = new TreePath(new Object[]{jIDStatusTree, jIDStatusTree.getGroup(I18N.gettext("main.main.roster.Servers"))});
                ServerTree.this.expandPath(treePath);
            }
        });
    }

    private void sendMessage(JIDStatus jIDStatus) {
        new SendMessage(this.backend, jIDStatus.getJID(), jIDStatus.getNick()).setVisible(true);
    }

    private void sendChat(JIDStatus jIDStatus) {
        this.main.chat(jIDStatus);
    }

    private void maybeShowPopup(MouseEvent mouseEvent, JIDStatus jIDStatus) {
        if (mouseEvent.isPopupTrigger()) {
            this.currentJIDStatus = jIDStatus;
            this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Object object;
        if (mouseEvent == null) {
            return null;
        }
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof PrimaryJIDStatus) {
            JIDStatus jIDStatus = ((PrimaryJIDStatus)object).getJIDPrimaryStatus();
            return "<HTML><P>" + I18N.gettext("main.main.roster.Status") + " " + Presence.toLongShow(jIDStatus.getShow()) + "</p><p>" + I18N.gettext("main.main.statusmenu.Status_message") + " " + jIDStatus.getStatus() + "</p><p> JID: " + jIDStatus.getJID() + "</p><p>" + I18N.gettext("main.main.roster.Subscription") + " " + jIDStatus.getSubscription() + "</p><p>" + I18N.gettext("main.main.roster.Waiting_Status") + " " + jIDStatus.getWaiting() + "</p></HTML>";
        }
        return null;
    }

    public void register(IQRegister iQRegister, String string) {
        this.backend.removeListener(RegisterListener.class, this);
        new RegisterWindow(this.backend, iQRegister, this.registerJID, string);
    }

    static class MyRenderer
    implements TreeCellRenderer {
        private JLabel renderer = new JLabel();

        public MyRenderer() {
            this.renderer.setOpaque(Preferences.getBoolean("jeti", "bmw", true));
            this.renderer.setBackground(UIManager.getColor("Tree.selectionBackground"));
            this.renderer.setForeground(UIManager.getColor("Tree.textForeground"));
            this.renderer.setFont(UIManager.getFont("Tree.font"));
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.renderer.setForeground(UIManager.getColor("Tree.textForeground"));
            if (bl) {
                this.renderer.setOpaque(true);
            } else {
                this.renderer.setOpaque(false);
            }
            this.renderer.setText(object.toString());
            if (bl3) {
                return this.makeComponent((JIDStatus)object);
            }
            if (object instanceof PrimaryJIDStatus) {
                return this.makeComponent(((PrimaryJIDStatus)object).getJIDPrimaryStatus());
            }
            if (!bl3 && bl2) {
                this.renderer.setIcon(StatusIcons.getImageIcon("arrowDown"));
            } else if (!bl3 && !bl2) {
                this.renderer.setIcon(StatusIcons.getImageIcon("arrowUp"));
            }
            return this.renderer;
        }

        private Component makeComponent(JIDStatus jIDStatus) {
            this.renderer.setIcon(StatusIcons.getStatusIcon(jIDStatus));
            return this.renderer;
        }
    }
}

