/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.UnknownJIDStatus;
import nu.fw.jeti.jabber.elements.IQTime;
import nu.fw.jeti.jabber.elements.IQVersion;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Message;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.plugins.RosterMenuListener;
import nu.fw.jeti.ui.ChatSplitPane;
import nu.fw.jeti.ui.ChatWindows;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class ChatWindow
extends JPanel {
    private JPanel jPanel1 = new JPanel();
    private ChatSplitPane chatSplitPane;
    private JButton jButton1 = new JButton();
    private Backend backend;
    private String thread;
    private JLabel lblComposing = new JLabel();
    private JIDStatus jidStatus;
    private JFrame window;
    private JMenu menu;
    private ChatWindows chatWindows;

    public ChatWindow(Backend backend, ChatWindows chatWindows, JFrame jFrame, JIDStatus jIDStatus, String string) {
        this.backend = backend;
        this.chatWindows = chatWindows;
        this.jidStatus = jIDStatus;
        this.thread = string;
        this.makeMenu();
        if (jFrame == null) {
            this.makeWindow();
            jFrame = this.window;
        }
        String string2 = backend.getMyJID().getUser();
        this.chatSplitPane = new ChatSplitPane(backend, jIDStatus, string2, string, this.menu, jFrame);
        this.init();
    }

    private void init() {
        this.lblComposing.setIcon(StatusIcons.getImageIcon("keys"));
        this.lblComposing.setVisible(false);
        I18N.setTextAndMnemonic("Send", this.jButton1);
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatWindow.this.jButton1_actionPerformed(actionEvent);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.jPanel1, "South");
        this.jPanel1.setLayout(new GridLayout(1, 3));
        this.jPanel1.add(this.lblComposing);
        this.jPanel1.add(this.jButton1);
        this.jPanel1.add(Box.createHorizontalStrut(0));
        this.add((Component)this.chatSplitPane, "Center");
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ChatWindow.this.chatSplitPane.requestFocusInWindow();
            }
        });
        this.chatSplitPane.setDividerLocation(Preferences.getInteger("jeti", "chatDivider", 200));
        if (this.window != null) {
            this.window.setVisible(true);
        }
    }

    private void makeMenu() {
        this.menu = new JMenu();
        I18N.setTextAndMnemonic("main.chat.menu", this.menu);
        JMenuItem jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic("main.main.rostermenu.Local_Time", jMenuItem, true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatWindow.this.backend.send(new InfoQuery(ChatWindow.this.jidStatus.getCompleteJID(), "get", new IQTime()));
            }
        });
        this.menu.add(jMenuItem);
        jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic("main.main.rostermenu.Local_Version", jMenuItem, true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatWindow.this.backend.send(new InfoQuery(ChatWindow.this.jidStatus.getCompleteJID(), "get", new IQVersion()));
            }
        });
        this.menu.add(jMenuItem);
        Map map = this.backend.getMain().getRosterMenuItems();
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                jMenuItem = new JMenuItem((String)entry.getKey());
                final RosterMenuListener rosterMenuListener = (RosterMenuListener)entry.getValue();
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        rosterMenuListener.actionPerformed(ChatWindow.this.jidStatus, null);
                    }
                });
                this.menu.add(jMenuItem);
            }
        }
    }

    public void addSplitBarListener(ComponentListener componentListener) {
        BasicSplitPaneDivider basicSplitPaneDivider = ((BasicSplitPaneUI)this.chatSplitPane.getUI()).getDivider();
        basicSplitPaneDivider.addComponentListener(componentListener);
    }

    public void removeSplitBarListener(ComponentListener componentListener) {
        BasicSplitPaneDivider basicSplitPaneDivider = ((BasicSplitPaneUI)this.chatSplitPane.getUI()).getDivider();
        basicSplitPaneDivider.removeComponentListener(componentListener);
    }

    public void setDividerLocation(int n) {
        this.chatSplitPane.setDividerLocation(n);
    }

    public void setParentFrame(JFrame jFrame) {
        this.chatSplitPane.setParentFrame(jFrame);
    }

    private void makeWindow() {
        this.window = new JFrame();
        this.setIcon(StatusIcons.getStatusIcon(this.jidStatus));
        if (this.jidStatus instanceof UnknownJIDStatus) {
            this.setTitle(this.jidStatus.getCompleteJID().toString());
        } else {
            this.setTitle(this.jidStatus.getNick());
        }
        this.window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Preferences.putInteger("jeti", "chatPosX", ChatWindow.this.window.getX());
                Preferences.putInteger("jeti", "chatPosY", ChatWindow.this.window.getY());
                Preferences.putInteger("jeti", "chatHeight", ChatWindow.this.window.getHeight());
                Preferences.putInteger("jeti", "chatWidth", ChatWindow.this.window.getWidth());
                Preferences.putInteger("jeti", "chatDivider", ChatWindow.this.chatSplitPane.getDividerLocation());
                ChatWindow.this.chatWindows.removeChatWindow(ChatWindow.this);
                ChatWindow.this.exit();
            }
        });
        this.window.addWindowFocusListener(new WindowAdapter(){

            public void windowGainedFocus(WindowEvent windowEvent) {
                ChatWindow.this.requestFocusInWindow();
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.menu);
        final JMenuItem jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic("main.chat.menu.Convert_to_tab", jMenuItem, true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatWindow.this.menu.remove(jMenuItem);
                ChatWindow.this.chatWindows.convertToTab(ChatWindow.this, ChatWindow.this.jidStatus);
                ChatWindow.this.window.dispose();
            }
        });
        this.menu.add(jMenuItem);
        this.window.setJMenuBar(jMenuBar);
        this.window.setContentPane(this);
        this.window.setSize(Preferences.getInteger("jeti", "chatWidth", 300), Preferences.getInteger("jeti", "chatHeight", 350));
    }

    public void changeToWindow() {
        this.makeWindow();
        this.chatSplitPane.setDividerLocation(Preferences.getInteger("jeti", "chatDivider", 200));
        this.chatSplitPane.setParentFrame(this.window);
        this.window.setVisible(true);
    }

    public void setLocationOnScreen(int n, int n2) {
        this.window.setLocation(n, n2);
    }

    public void setLocationOnScreen(ChatWindow chatWindow) {
        if (chatWindow.window != null) {
            this.window.setLocation(chatWindow.window.getX() + 50, chatWindow.window.getY() + 50);
        }
    }

    public void exit() {
        this.chatSplitPane.close();
        if (this.window != null) {
            this.window.dispose();
        }
    }

    public String getThread() {
        return this.thread;
    }

    public void appendMessage(Message message) {
        String string = this.jidStatus.getJID().equals(message.getFrom()) ? this.jidStatus.getNick() : message.getFrom().getUser();
        Runnable runnable = new Runnable(){

            public void run() {
                ChatWindow.this.lblComposing.setVisible(false);
            }
        };
        SwingUtilities.invokeLater(runnable);
        this.chatSplitPane.appendMessage(message, string);
    }

    public void appendPresenceChange(final Presence presence) {
        Runnable runnable = new Runnable(){

            public void run() {
                String string;
                ChatWindow.this.lblComposing.setVisible(false);
                int n = presence.getShow();
                String string2 = presence.getStatus();
                ChatWindow.this.setIcon(StatusIcons.getStatusIcon(ChatWindow.this.jidStatus));
                if (n == 7) {
                    string = " " + I18N.gettext("main.chat.is_currently_offline");
                    ChatWindow.this.setTitle(MessageFormat.format(I18N.gettext("main.chat.{0}_(offline)"), ChatWindow.this.jidStatus.getNick()));
                } else {
                    string = " " + I18N.gettext("main.chat.changed_status_to") + " " + Presence.toLongShow(n);
                    if (string2 != null) {
                        string = string + '\n' + I18N.gettext("main.chat.with_status_message") + " " + string2;
                    }
                    if (ChatWindow.this.jidStatus instanceof UnknownJIDStatus) {
                        ChatWindow.this.setTitle(ChatWindow.this.jidStatus.getCompleteJID().toString());
                    } else {
                        ChatWindow.this.setTitle(ChatWindow.this.jidStatus.getNick());
                    }
                }
                ChatWindow.this.chatSplitPane.appendSystemMessage(ChatWindow.this.jidStatus.getNick() + string);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public JIDStatus getJIDStatus() {
        return this.jidStatus;
    }

    public void composingID(String string) {
        if (string == null) {
            string = "";
        }
        this.chatSplitPane.composingID(string);
    }

    public void composing(String string) {
        if (string != null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    ChatWindow.this.lblComposing.setVisible(true);
                }
            };
            SwingUtilities.invokeLater(runnable);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    ChatWindow.this.lblComposing.setVisible(false);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    void jButton1_actionPerformed(ActionEvent actionEvent) {
        this.chatSplitPane.send();
    }

    private void setTitle(String string) {
        if (this.window != null) {
            this.window.setTitle(string);
        } else {
            this.chatWindows.setTitleAt(this, string);
        }
    }

    private void setIcon(ImageIcon imageIcon) {
        if (this.window != null) {
            this.window.setIconImage(imageIcon.getImage());
        } else {
            this.chatWindows.setIconAt(this, imageIcon);
        }
    }

    public JMenu getMenu() {
        return this.menu;
    }
}

