/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.backend;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.elements.DiscoIdentity;
import nu.fw.jeti.jabber.elements.IQDiscoInfo;
import nu.fw.jeti.jabber.elements.IQXCaps;
import nu.fw.jeti.jabber.elements.InfoQuery;

public class OwnCapabilities {
    private IQXCaps caps;
    private List features;
    private List coreFeatures;
    private Map capabilities;
    boolean changed = true;
    private Backend backend;

    public OwnCapabilities(Backend backend) {
        this.backend = backend;
        this.features = new ArrayList();
        this.coreFeatures = new ArrayList();
        this.capabilities = new HashMap();
        this.addCapability("http://jabber.org/protocol/disco#info");
        this.addCapability("jabber:iq:oob");
        this.addCapability("jabber:iq:time");
        this.addCapability("jabber:iq:version");
        this.addCapability("jabber:x:event");
    }

    public void addCapability(String string) {
        this.coreFeatures.add(string);
        this.features.add(string);
    }

    public void addCapability(String string, String string2) {
        this.features.add(string2);
        Object v = this.capabilities.get(string);
        if (v != null) {
            ((List)v).add(string2);
        } else {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(string2);
            this.capabilities.put(linkedList, string2);
        }
        this.changed = true;
    }

    public void removeCapability(String string, String string2) {
        this.features.remove(string2);
        this.capabilities.remove(string);
        this.changed = true;
    }

    private void createCaps() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.capabilities.keySet().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(' ');
        }
        this.caps = new IQXCaps("http://jeti.jabberstudio.org/caps", "0.7.7", stringBuffer.toString());
    }

    public void answerInfoRequest(InfoQuery infoQuery, IQDiscoInfo iQDiscoInfo) {
        LinkedList<DiscoIdentity> linkedList = new LinkedList<DiscoIdentity>();
        linkedList.add(new DiscoIdentity("client", "pc", null));
        IQDiscoInfo iQDiscoInfo2 = null;
        String string = iQDiscoInfo.getNode();
        if ("http://jeti.jabberstudio.org/caps#0.7.7".equals(string)) {
            iQDiscoInfo2 = new IQDiscoInfo(iQDiscoInfo.getNode(), linkedList, this.coreFeatures);
        } else if (string != null && string.startsWith("http://jeti.jabberstudio.org/caps#")) {
            List list = (List)this.capabilities.get(string.substring(string.lastIndexOf(35) + 1, string.length()));
            if (list != null) {
                iQDiscoInfo2 = new IQDiscoInfo(string, linkedList, list);
            }
        } else {
            iQDiscoInfo2 = new IQDiscoInfo(string, linkedList, this.features);
        }
        this.backend.send(new InfoQuery(infoQuery.getFrom(), "result", infoQuery.getID(), iQDiscoInfo2));
    }

    public IQXCaps getCaps() {
        if (this.changed) {
            this.createCaps();
            this.changed = false;
        }
        return this.caps;
    }
}

