/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.backend;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import nu.fw.jeti.events.DiscoveryListener;
import nu.fw.jeti.events.StatusChangeListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.DiscoveryInfo;
import nu.fw.jeti.jabber.elements.DiscoveryItem;
import nu.fw.jeti.jabber.elements.IQBrowse;
import nu.fw.jeti.jabber.elements.IQDiscoInfo;
import nu.fw.jeti.jabber.elements.IQDiscoItems;
import nu.fw.jeti.jabber.elements.InfoQuery;

public class Discovery
implements DiscoveryListener,
StatusChangeListener {
    private Backend backend;
    private Map infoCache = new HashMap();
    private Map itemCache = new HashMap();
    private Map itemRequests = new HashMap(5);
    private Map infoRequests = new HashMap(10);
    private Map timeoutTimers = new HashMap(20);
    private Timer timer = new Timer(true);
    private int idCount;

    public Discovery(Backend backend) {
        this.backend = backend;
    }

    public void getItems(JID jID, DiscoveryListener discoveryListener) {
        this.getItems(jID, discoveryListener, true);
    }

    public void getItems(JID jID, DiscoveryListener discoveryListener, boolean bl) {
        if (discoveryListener == null) {
            discoveryListener = this;
        }
        DiscoveryItem discoveryItem = null;
        if (!bl || null == (discoveryItem = (DiscoveryItem)this.itemCache.get(jID))) {
            String string = "Jeti_Disco_" + this.idCount++;
            InfoQuery infoQuery = new InfoQuery(jID, "get", string, new IQDiscoItems());
            this.timeout(infoQuery);
            this.itemRequests.put(string, discoveryListener);
            this.backend.send(infoQuery);
        } else {
            discoveryListener.discoveryItemResult(jID, discoveryItem);
        }
    }

    public void getInfo(JID jID, DiscoveryListener discoveryListener) {
        DiscoveryInfo discoveryInfo;
        if (discoveryListener == null) {
            discoveryListener = this;
        }
        if ((discoveryInfo = (DiscoveryInfo)this.infoCache.get(jID)) == null) {
            String string = "Jeti_Disco_" + this.idCount++;
            InfoQuery infoQuery = new InfoQuery(jID, "get", string, new IQDiscoInfo());
            this.timeout(infoQuery);
            this.infoRequests.put(string, discoveryListener);
            this.backend.send(infoQuery);
        } else {
            discoveryListener.discoveryInfoResult(jID, discoveryInfo);
        }
    }

    public void getItems(JID jID, String string, DiscoveryListener discoveryListener) {
        if (discoveryListener == null) {
            return;
        }
        String string2 = "Jeti_Disco_" + this.idCount++;
        InfoQuery infoQuery = new InfoQuery(jID, "get", string2, new IQDiscoItems(string));
        this.timeout(infoQuery);
        this.itemRequests.put(string2, discoveryListener);
        this.backend.send(infoQuery);
    }

    public void getInfo(JID jID, String string, DiscoveryListener discoveryListener) {
        DiscoveryInfo discoveryInfo;
        if (discoveryListener == null) {
            discoveryListener = this;
        }
        if ((discoveryInfo = (DiscoveryInfo)this.infoCache.get(jID)) == null) {
            String string2 = "Jeti_Disco_" + this.idCount++;
            InfoQuery infoQuery = new InfoQuery(jID, "get", string2, new IQDiscoInfo(string));
            this.timeout(infoQuery);
            this.infoRequests.put(string2, discoveryListener);
            this.backend.send(infoQuery);
        } else {
            discoveryListener.discoveryInfoResult(jID, discoveryInfo);
        }
    }

    public void discoveryInfoResult(JID jID, String string, IQDiscoInfo iQDiscoInfo) {
        TimerTask timerTask = (TimerTask)this.timeoutTimers.remove(string);
        if (timerTask != null) {
            timerTask.cancel();
        }
        this.infoCache.put(jID, iQDiscoInfo);
        DiscoveryListener discoveryListener = (DiscoveryListener)this.infoRequests.remove(string);
        if (discoveryListener != null) {
            discoveryListener.discoveryInfoResult(jID, iQDiscoInfo);
        }
    }

    public void discoveryItemResult(JID jID, String string, IQDiscoItems iQDiscoItems) {
        TimerTask timerTask = (TimerTask)this.timeoutTimers.remove(string);
        if (timerTask != null) {
            timerTask.cancel();
        }
        this.itemCache.put(jID, iQDiscoItems);
        DiscoveryListener discoveryListener = (DiscoveryListener)this.itemRequests.remove(string);
        if (discoveryListener != null) {
            discoveryListener.discoveryItemResult(jID, iQDiscoItems);
        }
    }

    public void discoError(String string, JID jID) {
        Object v;
        TimerTask timerTask = (TimerTask)this.timeoutTimers.remove(string);
        if (timerTask != null) {
            timerTask.cancel();
        }
        if ((v = this.infoRequests.remove(string)) != null) {
            IQBrowse iQBrowse = new IQBrowse(jID);
            if (this.infoCache.get(jID) == null) {
                this.infoCache.put(jID, iQBrowse);
            }
            ((DiscoveryListener)v).discoveryInfoResult(jID, iQBrowse);
        } else {
            v = this.itemRequests.remove(string);
            if (v != null) {
                IQBrowse iQBrowse = new IQBrowse(jID);
                if (this.itemCache.get(jID) == null) {
                    this.itemCache.put(jID, iQBrowse);
                }
                ((DiscoveryListener)v).discoveryItemResult(jID, iQBrowse);
            }
        }
    }

    public void discoveryInfoResult(JID jID, DiscoveryInfo discoveryInfo) {
    }

    public void discoveryItemResult(JID jID, DiscoveryItem discoveryItem) {
    }

    private void timeout(final InfoQuery infoQuery) {
        TimerTask timerTask = new TimerTask(){

            public void run() {
                System.out.println("timeout " + infoQuery);
                Discovery.this.discoError(infoQuery.getID(), infoQuery.getTo());
            }
        };
        this.timer.schedule(timerTask, 60000L);
        this.timeoutTimers.put(infoQuery.getID(), timerTask);
    }

    public void connectionChanged(boolean bl) {
        if (!bl) {
            this.infoRequests = new HashMap(10);
            this.itemRequests = new HashMap(5);
            this.infoCache = new HashMap();
            this.itemCache = new HashMap();
        }
    }

    public void ownPresenceChanged(int n, String string) {
    }

    public void exit() {
    }
}

