/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.backend;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import nu.fw.jeti.backend.Capabilities;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.events.DiscoveryListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.DiscoveryInfo;
import nu.fw.jeti.jabber.elements.DiscoveryItem;
import nu.fw.jeti.jabber.elements.IQDiscoInfo;
import nu.fw.jeti.jabber.elements.IQXCaps;
import nu.fw.jeti.jabber.handlers.IQDiscoInfoHandler;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class CapabilitiesCache
implements DiscoveryListener {
    private Map capabilities;
    private Map cache;
    private Backend backend;

    public CapabilitiesCache(Backend backend) {
        this.backend = backend;
        this.capabilities = new HashMap();
        this.cache = new HashMap();
        try {
            FileInputStream fileInputStream = new FileInputStream(Start.path + "capabilitiesCache.xml");
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            sAXParser.parse((InputStream)fileInputStream, (DefaultHandler)new DiscoInfoHandler(this.cache));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setCapability(JID jID, IQXCaps iQXCaps) {
        String string = iQXCaps.getNode() + "#" + iQXCaps.getVer();
        this.addCap(jID, string);
        if (iQXCaps.getExt() != null) {
            String[] stringArray = iQXCaps.getExt().split(" ");
            for (int i = 0; i < stringArray.length; ++i) {
                string = iQXCaps.getNode() + "#" + stringArray[i];
                this.addCap(jID, string);
            }
        }
    }

    private void addCap(JID jID, String string) {
        if (this.cache.containsKey(string)) {
            this.getJIDCapabilities(jID).addCapabilities((IQDiscoInfo)this.cache.get(string));
        } else {
            this.backend.getInfo(jID, string, this);
        }
    }

    private Capabilities getJIDCapabilities(JID jID) {
        Capabilities capabilities = null;
        if (this.capabilities.containsKey(jID)) {
            capabilities = (Capabilities)this.capabilities.get(jID);
        } else {
            capabilities = new Capabilities();
            this.capabilities.put(jID, capabilities);
        }
        return capabilities;
    }

    public void discoveryInfoResult(JID jID, DiscoveryInfo discoveryInfo) {
        if (!discoveryInfo.hasFeatures()) {
            return;
        }
        IQDiscoInfo iQDiscoInfo = (IQDiscoInfo)discoveryInfo;
        this.cache.put(iQDiscoInfo.getNode(), iQDiscoInfo);
        this.getJIDCapabilities(jID).addCapabilities(iQDiscoInfo);
    }

    public void discoveryItemResult(JID jID, DiscoveryItem discoveryItem) {
    }

    public boolean hasCapability(JID jID, String string) {
        return this.getJIDCapabilities(jID).hasCapability(string);
    }

    public void save() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version='1.0'?>");
        stringBuffer.append("<queries>");
        Object object = this.cache.values().iterator();
        while (object.hasNext()) {
            ((IQDiscoInfo)object.next()).appendToXML(stringBuffer);
            stringBuffer.append("\n");
        }
        stringBuffer.append("</queries>");
        System.out.println(stringBuffer.toString());
        try {
            object = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(Start.path + "capabilitiesCache.xml"), "UTF8"));
            ((Writer)object).write(stringBuffer.toString());
            ((BufferedWriter)object).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static class DiscoInfoHandler
    extends DefaultHandler {
        private Map queries;
        private IQDiscoInfoHandler discoHandler;

        public DiscoInfoHandler(Map map) {
            this.queries = map;
            this.discoHandler = new IQDiscoInfoHandler();
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (!string3.equals("queries")) {
                if (string3.equals("query")) {
                    this.discoHandler.startHandling(attributes);
                } else {
                    this.discoHandler.startElement(string3, attributes);
                }
            }
        }

        public void endElement(String string, String string2, String string3) {
            if (string3.equals("query")) {
                IQDiscoInfo iQDiscoInfo = (IQDiscoInfo)this.discoHandler.build();
                this.queries.put(iQDiscoInfo.getNode(), iQDiscoInfo);
            }
        }
    }
}

