/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.metaltheme;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.plugins.PreferencesPanel;
import nu.fw.jeti.plugins.metaltheme.MyTheme;
import nu.fw.jeti.util.Preferences;

public class PrefPanel
extends PreferencesPanel {
    private Backend backend;
    private MyTheme theme = new MyTheme();
    private JButton[] buttons = new JButton[8];

    public PrefPanel(Backend backend) {
        this.backend = backend;
        this.theme.load();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        ColorUIResource[] colorUIResourceArray = this.theme.getColors();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 0, 3);
        this.addColorButton("Primary Color 1", colorUIResourceArray, 0, gridBagConstraints);
        this.addColorButton("Primary Color 2", colorUIResourceArray, 1, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.addColorButton("Primary Color 3", colorUIResourceArray, 2, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.addColorButton("Secondary Color 1", colorUIResourceArray, 3, gridBagConstraints);
        this.addColorButton("Secondary Color 2", colorUIResourceArray, 4, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.addColorButton("Secondary Color 3", colorUIResourceArray, 5, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.addColorButton("Background color", colorUIResourceArray, 6, gridBagConstraints);
        this.addColorButton("Foreground color", colorUIResourceArray, 7, gridBagConstraints);
        this.update();
    }

    private void addColorButton(String string, final ColorUIResource[] colorUIResourceArray, final int n, GridBagConstraints gridBagConstraints) {
        this.buttons[n] = new JButton(string);
        this.buttons[n].setBackground(colorUIResourceArray[n]);
        this.buttons[n].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog((Component)((Object)PrefPanel.this), "primary1", null);
                colorUIResourceArray[n] = new ColorUIResource(color);
                PrefPanel.this.update();
            }
        });
        this.add(this.buttons[n], gridBagConstraints);
    }

    private void update() {
        MetalLookAndFeel.setCurrentTheme(this.theme);
        try {
            UIManager.setLookAndFeel(new MetalLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
        SwingUtilities.updateComponentTreeUI(this.backend.getMainWindow());
        if (this.getTopLevelAncestor() != null) {
            SwingUtilities.updateComponentTreeUI(this.getTopLevelAncestor());
        }
        ColorUIResource[] colorUIResourceArray = this.theme.getColors();
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setBackground(colorUIResourceArray[i]);
        }
    }

    public void savePreferences() {
        ColorUIResource[] colorUIResourceArray = this.theme.getColors();
        for (int i = 0; i < colorUIResourceArray.length; ++i) {
            Preferences.putInteger((String)"metaltheme", (String)("color" + i), (int)colorUIResourceArray[i].getRGB());
        }
    }
}

