/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.jabber.elements;

import java.text.MessageFormat;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;
import nu.fw.jeti.util.Preferences;

public class IQVersion
extends Extension
implements IQExtension {
    private String os;
    private String name;
    private String version;

    public IQVersion() {
    }

    public IQVersion(String string, String string2, String string3) {
        this.os = string3;
        this.name = string;
        this.version = string2;
    }

    public String getOS() {
        return this.os;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public void execute(InfoQuery infoQuery, Backend backend) {
        String string = infoQuery.getType();
        if (string.equals("get")) {
            if (Preferences.getBoolean("jeti", "privacy", false)) {
                return;
            }
            String string2 = "";
            if (Start.applet) {
                string2 = "A";
            } else if (Start.webstart) {
                string2 = "W";
            }
            IQVersion iQVersion = new IQVersion("JETI", "0.7.7" + string2 + " - " + Start.BUILD_DATE, System.getProperty("os.name") + " " + System.getProperty("os.version"));
            backend.send(new InfoQuery(infoQuery.getFrom(), "result", infoQuery.getID(), iQVersion));
        } else if (string.equals("result")) {
            this.versionPopup(infoQuery.getFrom().toString(), this.getName(), this.getVersion(), this.getOS());
        } else if (string.equals("error")) {
            Popups.errorPopup(infoQuery.getErrorDescription(), I18N.gettext("main.error.Version_Error"));
        }
    }

    private void versionPopup(String string, String string2, String string3, String string4) {
        Popups.popup(MessageFormat.format(I18N.gettext("main.popup.{0}_uses_{1},_version_{2},_On_{3}"), string, string2, string3, string4), I18N.gettext("main.popup.Version"), 1);
    }

    public void appendToXML(StringBuffer stringBuffer) {
        stringBuffer.append("<query xmlns=\"jabber:iq:version\"");
        if (this.name == null && this.version == null && this.os == null) {
            stringBuffer.append("/>");
            return;
        }
        stringBuffer.append('>');
        IQVersion.appendElement(stringBuffer, "name", this.name);
        IQVersion.appendElement(stringBuffer, "version", this.version);
        IQVersion.appendElement(stringBuffer, "os", this.os);
        stringBuffer.append("</query>");
    }
}

