/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import cryptix.jce.util.Util;
import java.security.spec.AlgorithmParameterSpec;

public class RC5ParameterSpec
implements AlgorithmParameterSpec {
    private final int version;
    private final int rounds;
    private final int wordSize;
    private final byte[] iv;

    public RC5ParameterSpec(int version, int rounds, int wordSize) {
        this.version = version;
        this.rounds = rounds;
        this.wordSize = wordSize;
        this.iv = null;
    }

    public RC5ParameterSpec(int version, int rounds, int wordSize, byte[] iv) {
        this.version = version;
        this.rounds = rounds;
        this.wordSize = wordSize;
        this.iv = (byte[])iv.clone();
    }

    public RC5ParameterSpec(int version, int rounds, int wordSize, byte[] iv, int offset) {
        this.version = version;
        this.rounds = rounds;
        this.wordSize = wordSize;
        this.iv = new byte[2 * (wordSize / 8)];
        System.arraycopy(iv, offset, this.iv, 0, this.iv.length);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RC5ParameterSpec)) {
            return false;
        }
        RC5ParameterSpec that = (RC5ParameterSpec)obj;
        return this.version == that.version && this.rounds == that.rounds && this.wordSize == that.wordSize && Util.equals(this.iv, that.iv);
    }

    public byte[] getIV() {
        return this.iv == null ? this.iv : (byte[])this.iv.clone();
    }

    public int getRounds() {
        return this.rounds;
    }

    public int getVersion() {
        return this.version;
    }

    public int getWordSize() {
        return this.wordSize;
    }

    public int hashCode() {
        return 0;
    }
}

