/*
 * Decompiled with CFR 0.152.
 */
package cryptix.message;

import cryptix.message.MessageException;

public abstract class Message {
    private String format;
    private transient int cachedHashCode = -1;

    protected Message(String format) {
        this.format = format;
    }

    public boolean equals(Object other) {
        try {
            byte[] thatBytes;
            if (!(other instanceof Message)) {
                return false;
            }
            Message that = (Message)other;
            if (this.hashCode() != that.hashCode()) {
                return false;
            }
            byte[] thisBytes = this.getEncoded();
            if (thisBytes.length != (thatBytes = that.getEncoded()).length) {
                return false;
            }
            int i = 0;
            while (i < thisBytes.length) {
                if (thisBytes[i] != thatBytes[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (MessageException messageException) {
            return false;
        }
    }

    public abstract Object getAttribute(String var1) throws IllegalArgumentException, MessageException;

    public abstract byte[] getEncoded() throws MessageException;

    public String getFormat() {
        return this.format;
    }

    public int hashCode() {
        if (this.cachedHashCode != -1) {
            return this.cachedHashCode;
        }
        try {
            byte[] thisBytes = this.getEncoded();
            int hash = 0;
            int i = 0;
            while (i < thisBytes.length) {
                hash = (hash << 7 | hash >>> 25) ^ thisBytes[i] & 0xFF;
                ++i;
            }
            this.cachedHashCode = hash;
            return this.cachedHashCode;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
        catch (MessageException messageException) {
            return 0;
        }
    }
}

