/*
 * Decompiled with CFR 0.152.
 */
package cryptix.message;

import cryptix.message.EncryptedMessageBuilder;
import cryptix.message.EncryptedMessageBuilderSpi;
import cryptix.message.KeyBundleMessageBuilderSpi;
import cryptix.message.Message;
import cryptix.message.MessageException;
import cryptix.message.Support;
import cryptix.pki.KeyBundle;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;

public class KeyBundleMessageBuilder {
    private final KeyBundleMessageBuilderSpi spi;
    private final Provider provider;
    private final String format;

    protected KeyBundleMessageBuilder(KeyBundleMessageBuilderSpi builderSpi, Provider provider, String format) {
        this.spi = builderSpi;
        this.provider = provider;
        this.format = format;
    }

    public final Message build() throws IllegalStateException, MessageException {
        return this.spi.engineBuild();
    }

    public final String getFormat() {
        return this.format;
    }

    public static EncryptedMessageBuilder getInstance(String format) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("EncryptedMessageBuilder", format);
        return new EncryptedMessageBuilder((EncryptedMessageBuilderSpi)o[0], (Provider)o[1], format);
    }

    public static EncryptedMessageBuilder getInstance(String format, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] o = Support.getImplementation("EncryptedMessageBuilder", format, provider);
        return new EncryptedMessageBuilder((EncryptedMessageBuilderSpi)o[0], (Provider)o[1], format);
    }

    public static EncryptedMessageBuilder getInstance(String format, Provider provider) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("EncryptedMessageBuilder", format, provider);
        return new EncryptedMessageBuilder((EncryptedMessageBuilderSpi)o[0], (Provider)o[1], format);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(KeyBundle contents) throws IllegalStateException, MessageException {
        this.spi.engineInit(contents);
    }

    public final void setAttribute(String name, Object attr) throws IllegalStateException, IllegalArgumentException, MessageException {
        this.spi.engineSetAttribute(name, attr);
    }
}

