/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.md;

import cryptix.jce.provider.md.PaddingMD;

public class SHA256
extends PaddingMD
implements Cloneable {
    private static final int HASH_SIZE = 32;
    private static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private final int[] context;
    private final int[] buffer;

    public SHA256() {
        super(32, 1);
        this.context = new int[8];
        this.buffer = new int[64];
        this.coreReset();
    }

    private SHA256(SHA256 src) {
        super(src);
        this.context = (int[])src.context.clone();
        this.buffer = (int[])src.buffer.clone();
    }

    private final int Ch(int x, int y, int z) {
        return x & y ^ ~x & z;
    }

    private final int Maj(int x, int y, int z) {
        return x & y ^ x & z ^ y & z;
    }

    private final int R(int off, int x) {
        return x >>> off;
    }

    private final int S(int off, int x) {
        return x >>> off | x << 32 - off;
    }

    private final int Sig0(int x) {
        return this.S(2, x) ^ this.S(13, x) ^ this.S(22, x);
    }

    private final int Sig1(int x) {
        return this.S(6, x) ^ this.S(11, x) ^ this.S(25, x);
    }

    public Object clone() {
        return new SHA256(this);
    }

    protected void coreDigest(byte[] buf, int off) {
        int i = 0;
        while (i < this.context.length) {
            int j = 0;
            while (j < 4) {
                buf[off + (i * 4 + (3 - j))] = (byte)(this.context[i] >>> 8 * j);
                ++j;
            }
            ++i;
        }
    }

    protected void coreReset() {
        this.context[0] = 1779033703;
        this.context[1] = -1150833019;
        this.context[2] = 1013904242;
        this.context[3] = -1521486534;
        this.context[4] = 1359893119;
        this.context[5] = -1694144372;
        this.context[6] = 528734635;
        this.context[7] = 1541459225;
    }

    protected void coreUpdate(byte[] block, int offset) {
        int[] W = this.buffer;
        int i = 0;
        while (i < 16) {
            W[i] = block[offset++] << 24 | (block[offset++] & 0xFF) << 16 | (block[offset++] & 0xFF) << 8 | block[offset++] & 0xFF;
            ++i;
        }
        int i2 = 16;
        while (i2 < 64) {
            W[i2] = this.sig1(W[i2 - 2]) + W[i2 - 7] + this.sig0(W[i2 - 15]) + W[i2 - 16];
            ++i2;
        }
        int a = this.context[0];
        int b = this.context[1];
        int c = this.context[2];
        int d = this.context[3];
        int e = this.context[4];
        int f = this.context[5];
        int g = this.context[6];
        int h = this.context[7];
        int i3 = 0;
        while (i3 < 64) {
            int T1 = h + this.Sig1(e) + this.Ch(e, f, g) + K[i3] + W[i3];
            int T2 = this.Sig0(a) + this.Maj(a, b, c);
            h = g;
            g = f;
            f = e;
            e = d + T1;
            d = c;
            c = b;
            b = a;
            a = T1 + T2;
            ++i3;
        }
        this.context[0] = this.context[0] + a;
        this.context[1] = this.context[1] + b;
        this.context[2] = this.context[2] + c;
        this.context[3] = this.context[3] + d;
        this.context[4] = this.context[4] + e;
        this.context[5] = this.context[5] + f;
        this.context[6] = this.context[6] + g;
        this.context[7] = this.context[7] + h;
    }

    private final int sig0(int x) {
        return this.S(7, x) ^ this.S(18, x) ^ this.R(3, x);
    }

    private final int sig1(int x) {
        return this.S(17, x) ^ this.S(19, x) ^ this.R(10, x);
    }
}

