/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.md;

import cryptix.jce.provider.md.PaddingMD;

public final class MD5
extends PaddingMD
implements Cloneable {
    private static final int HASH_SIZE = 16;
    private int[] context = new int[4];
    private int[] X = new int[16];

    public MD5() {
        super(16, 0);
        this.coreReset();
    }

    private MD5(MD5 src) {
        super(src);
        this.context = (int[])src.context.clone();
        this.X = (int[])src.X.clone();
    }

    private static int F(int x, int y, int z) {
        return z ^ x & (y ^ z);
    }

    private static int FF(int a, int b, int c, int d, int k, int s, int t) {
        a += k + t + MD5.F(b, c, d);
        a = a << s | a >>> -s;
        return a + b;
    }

    private static int G(int x, int y, int z) {
        return y ^ z & (x ^ y);
    }

    private static int GG(int a, int b, int c, int d, int k, int s, int t) {
        a += k + t + MD5.G(b, c, d);
        a = a << s | a >>> -s;
        return a + b;
    }

    private static int H(int x, int y, int z) {
        return x ^ y ^ z;
    }

    private static int HH(int a, int b, int c, int d, int k, int s, int t) {
        a += k + t + MD5.H(b, c, d);
        a = a << s | a >>> -s;
        return a + b;
    }

    private static int I(int x, int y, int z) {
        return y ^ (x | ~z);
    }

    private int II(int a, int b, int c, int d, int k, int s, int t) {
        a += k + t + MD5.I(b, c, d);
        a = a << s | a >>> -s;
        return a + b;
    }

    public Object clone() {
        return new MD5(this);
    }

    protected void coreDigest(byte[] buf, int off) {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                buf[off + (i * 4 + j)] = (byte)(this.context[i] >>> 8 * j);
                ++j;
            }
            ++i;
        }
    }

    protected void coreReset() {
        this.context[0] = 1732584193;
        this.context[1] = -271733879;
        this.context[2] = -1732584194;
        this.context[3] = 271733878;
    }

    protected void coreUpdate(byte[] block, int offset) {
        int i = 0;
        while (i < 16) {
            this.X[i] = block[offset++] & 0xFF | (block[offset++] & 0xFF) << 8 | (block[offset++] & 0xFF) << 16 | (block[offset++] & 0xFF) << 24;
            ++i;
        }
        int a = this.context[0];
        int b = this.context[1];
        int c = this.context[2];
        int d = this.context[3];
        a = MD5.FF(a, b, c, d, this.X[0], 7, -680876936);
        d = MD5.FF(d, a, b, c, this.X[1], 12, -389564586);
        c = MD5.FF(c, d, a, b, this.X[2], 17, 606105819);
        b = MD5.FF(b, c, d, a, this.X[3], 22, -1044525330);
        a = MD5.FF(a, b, c, d, this.X[4], 7, -176418897);
        d = MD5.FF(d, a, b, c, this.X[5], 12, 1200080426);
        c = MD5.FF(c, d, a, b, this.X[6], 17, -1473231341);
        b = MD5.FF(b, c, d, a, this.X[7], 22, -45705983);
        a = MD5.FF(a, b, c, d, this.X[8], 7, 1770035416);
        d = MD5.FF(d, a, b, c, this.X[9], 12, -1958414417);
        c = MD5.FF(c, d, a, b, this.X[10], 17, -42063);
        b = MD5.FF(b, c, d, a, this.X[11], 22, -1990404162);
        a = MD5.FF(a, b, c, d, this.X[12], 7, 1804603682);
        d = MD5.FF(d, a, b, c, this.X[13], 12, -40341101);
        c = MD5.FF(c, d, a, b, this.X[14], 17, -1502002290);
        b = MD5.FF(b, c, d, a, this.X[15], 22, 1236535329);
        a = MD5.GG(a, b, c, d, this.X[1], 5, -165796510);
        d = MD5.GG(d, a, b, c, this.X[6], 9, -1069501632);
        c = MD5.GG(c, d, a, b, this.X[11], 14, 643717713);
        b = MD5.GG(b, c, d, a, this.X[0], 20, -373897302);
        a = MD5.GG(a, b, c, d, this.X[5], 5, -701558691);
        d = MD5.GG(d, a, b, c, this.X[10], 9, 38016083);
        c = MD5.GG(c, d, a, b, this.X[15], 14, -660478335);
        b = MD5.GG(b, c, d, a, this.X[4], 20, -405537848);
        a = MD5.GG(a, b, c, d, this.X[9], 5, 568446438);
        d = MD5.GG(d, a, b, c, this.X[14], 9, -1019803690);
        c = MD5.GG(c, d, a, b, this.X[3], 14, -187363961);
        b = MD5.GG(b, c, d, a, this.X[8], 20, 1163531501);
        a = MD5.GG(a, b, c, d, this.X[13], 5, -1444681467);
        d = MD5.GG(d, a, b, c, this.X[2], 9, -51403784);
        c = MD5.GG(c, d, a, b, this.X[7], 14, 1735328473);
        b = MD5.GG(b, c, d, a, this.X[12], 20, -1926607734);
        a = MD5.HH(a, b, c, d, this.X[5], 4, -378558);
        d = MD5.HH(d, a, b, c, this.X[8], 11, -2022574463);
        c = MD5.HH(c, d, a, b, this.X[11], 16, 1839030562);
        b = MD5.HH(b, c, d, a, this.X[14], 23, -35309556);
        a = MD5.HH(a, b, c, d, this.X[1], 4, -1530992060);
        d = MD5.HH(d, a, b, c, this.X[4], 11, 1272893353);
        c = MD5.HH(c, d, a, b, this.X[7], 16, -155497632);
        b = MD5.HH(b, c, d, a, this.X[10], 23, -1094730640);
        a = MD5.HH(a, b, c, d, this.X[13], 4, 681279174);
        d = MD5.HH(d, a, b, c, this.X[0], 11, -358537222);
        c = MD5.HH(c, d, a, b, this.X[3], 16, -722521979);
        b = MD5.HH(b, c, d, a, this.X[6], 23, 76029189);
        a = MD5.HH(a, b, c, d, this.X[9], 4, -640364487);
        d = MD5.HH(d, a, b, c, this.X[12], 11, -421815835);
        c = MD5.HH(c, d, a, b, this.X[15], 16, 530742520);
        b = MD5.HH(b, c, d, a, this.X[2], 23, -995338651);
        a = this.II(a, b, c, d, this.X[0], 6, -198630844);
        d = this.II(d, a, b, c, this.X[7], 10, 1126891415);
        c = this.II(c, d, a, b, this.X[14], 15, -1416354905);
        b = this.II(b, c, d, a, this.X[5], 21, -57434055);
        a = this.II(a, b, c, d, this.X[12], 6, 1700485571);
        d = this.II(d, a, b, c, this.X[3], 10, -1894986606);
        c = this.II(c, d, a, b, this.X[10], 15, -1051523);
        b = this.II(b, c, d, a, this.X[1], 21, -2054922799);
        a = this.II(a, b, c, d, this.X[8], 6, 1873313359);
        d = this.II(d, a, b, c, this.X[15], 10, -30611744);
        c = this.II(c, d, a, b, this.X[6], 15, -1560198380);
        b = this.II(b, c, d, a, this.X[13], 21, 1309151649);
        a = this.II(a, b, c, d, this.X[4], 6, -145523070);
        d = this.II(d, a, b, c, this.X[11], 10, -1120210379);
        c = this.II(c, d, a, b, this.X[2], 15, 718787259);
        b = this.II(b, c, d, a, this.X[9], 21, -343485551);
        this.context[0] = this.context[0] + a;
        this.context[1] = this.context[1] + b;
        this.context[2] = this.context[2] + c;
        this.context[3] = this.context[3] + d;
    }
}

