/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.Mode;
import cryptix.jce.provider.cipher.Padding;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

final class PaddingPKCS5
extends Padding {
    PaddingPKCS5(Mode mode) {
        super(mode);
    }

    final byte[] corePad(byte[] input, int inputLen) throws IllegalBlockSizeException {
        if (input == null) {
            input = new byte[]{};
        }
        int pad = this.getPadSize(inputLen);
        byte[] b = new byte[pad + inputLen];
        System.arraycopy(input, 0, b, 0, inputLen);
        int i = 0;
        while (i < pad) {
            b[inputLen + i] = (byte)pad;
            ++i;
        }
        return b;
    }

    final int coreUnPad(byte[] input, int inputLen) throws BadPaddingException {
        int padlen = input[inputLen - 1] & 0xFF;
        int i = 0;
        while (i < padlen) {
            if ((input[inputLen - i - 1] & 0xFF) != padlen) {
                throw new BadPaddingException("Invalid padding in final block");
            }
            ++i;
        }
        if (padlen > inputLen) {
            throw new BadPaddingException("Invalid padding in final block.");
        }
        return inputLen - padlen;
    }

    final int getPadSize(int inputLen) {
        int bs = this.getBlockSize();
        return bs - (inputLen + this.getBufSize()) % bs;
    }
}

