/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.openpgp;

import cryptix.jce.provider.CryptixCrypto;
import cryptix.message.EncryptedMessage;
import cryptix.message.EncryptedMessageBuilder;
import cryptix.message.KeyBundleMessage;
import cryptix.message.LiteralMessage;
import cryptix.message.LiteralMessageBuilder;
import cryptix.message.Message;
import cryptix.message.MessageException;
import cryptix.message.MessageFactory;
import cryptix.message.NotEncryptedToParameterException;
import cryptix.message.SignedMessageBuilder;
import cryptix.openpgp.PGPDetachedSignatureMessage;
import cryptix.openpgp.PGPKeyBundle;
import cryptix.openpgp.PGPSignedMessage;
import cryptix.openpgp.provider.CryptixOpenPGP;
import cryptix.openpgp.util.PGPArmoury;
import cryptix.pki.KeyBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPasswordField;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.events.PresenceListener;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.jabber.elements.XExtension;
import nu.fw.jeti.plugins.OpenPGP;
import nu.fw.jeti.plugins.openpgp.XEncrypted;
import nu.fw.jeti.plugins.openpgp.XSigned;
import nu.fw.jeti.util.Popups;

public class Encrypter
implements OpenPGP,
PresenceListener {
    private static Encrypter encrypter;
    private char[] passpharse;
    private Map keys = new HashMap();
    private List usesPGP = new ArrayList();
    private KeyBundle secretKey;

    public Encrypter() {
        encrypter = this;
        Security.addProvider((Provider)new CryptixCrypto());
        Security.addProvider((Provider)new CryptixOpenPGP());
        this.secretKey = this.readKey("jeti.sec");
        this.importKeys();
    }

    public static Encrypter getInstance() {
        return encrypter;
    }

    private void importKeys() {
        File file = new File(Start.path + "keys");
        if (!file.exists()) {
            Popups.messagePopup((String)"No jeti keys directory found", (String)"Keys not found");
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string = fileArray[i].getName();
            string = string.substring(0, string.length() - 4);
            JID jID = null;
            try {
                jID = JID.checkedJIDFromString((String)string);
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            System.out.println(string);
            this.keys.put(jID, this.readKey(fileArray[i].getPath()));
        }
    }

    private KeyBundle readKey(String string) {
        PGPKeyBundle pGPKeyBundle = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            MessageFactory messageFactory = MessageFactory.getInstance((String)"OpenPGP");
            Collection collection = messageFactory.generateMessages((InputStream)fileInputStream);
            fileInputStream.close();
            KeyBundleMessage keyBundleMessage = (KeyBundleMessage)collection.iterator().next();
            pGPKeyBundle = (PGPKeyBundle)keyBundleMessage.getKeyBundle();
        }
        catch (IOException iOException) {
            System.err.println("IOException... You did remember to run the GenerateAndWriteKey example first, right?");
            iOException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("Cannot find the OpenPGP KeyBundleFactory. This usually means that the Cryptix OpenPGP provider is not installed correctly.");
            noSuchAlgorithmException.printStackTrace();
        }
        catch (MessageException messageException) {
            System.err.println("Reading keybundle failed.");
            messageException.printStackTrace();
        }
        return pGPKeyBundle;
    }

    public Extension signPresence(String string) {
        if (this.passpharse == null) {
            this.askPassphrase();
        }
        XSigned xSigned = null;
        if (string != null) {
            xSigned = new XSigned(this.sign(string));
        }
        return xSigned;
    }

    private void askPassphrase() {
        final JDialog jDialog = new JDialog((Frame)null, "Please give your encryption passpharse", true);
        final JPasswordField jPasswordField = new JPasswordField();
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)jPasswordField, "Center");
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Encrypter.access$002(Encrypter.this, jPasswordField.getPassword());
                jDialog.setVisible(false);
            }
        });
        jDialog.getContentPane().add((Component)jButton, "South");
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(true);
    }

    public String sign(String string) {
        LiteralMessageBuilder literalMessageBuilder;
        if (this.passpharse == null) {
            return null;
        }
        Message message = null;
        try {
            literalMessageBuilder = LiteralMessageBuilder.getInstance((String)"OpenPGP");
            literalMessageBuilder.init(string.getBytes());
            message = literalMessageBuilder.build();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("Cannot find the OpenPGP LiteralMessageBuilder. This usually means that the Cryptix OpenPGP provider is not installed correctly.");
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
        catch (MessageException messageException) {
            System.err.println("Generating the message failed.");
            messageException.printStackTrace();
            return null;
        }
        literalMessageBuilder = null;
        try {
            SignedMessageBuilder signedMessageBuilder = SignedMessageBuilder.getInstance((String)"OpenPGP");
            signedMessageBuilder.init(message);
            signedMessageBuilder.addSigner(this.secretKey, this.passpharse);
            literalMessageBuilder = (PGPSignedMessage)signedMessageBuilder.build();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("Cannot find the OpenPGP SignedMessageBuilder. This usually means that the Cryptix OpenPGP provider is not installed correctly.");
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            System.err.println("Incorrect passphrase.");
            unrecoverableKeyException.printStackTrace();
            return null;
        }
        catch (MessageException messageException) {
            System.err.println("Generating the message failed.");
            messageException.printStackTrace();
            return null;
        }
        try {
            return PGPArmoury.armour((byte[])literalMessageBuilder.getDetachedSignature().getEncoded());
        }
        catch (MessageException messageException) {
            System.err.println("Writing the message failed.");
            messageException.printStackTrace();
            return null;
        }
    }

    public void presenceChanged(Presence presence) {
        if (presence.hasExtensions()) {
            Iterator iterator = presence.getExtensions();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof XSigned)) continue;
                this.verify(presence.getFrom(), ((XSigned)((Object)e)).getSigned(), presence.getStatus());
                break;
            }
        } else {
            this.usesPGP.remove(presence.getFrom());
        }
    }

    private void verify(JID jID, String string, String string2) {
        LiteralMessageBuilder literalMessageBuilder;
        System.out.println("verifying");
        string = string.replaceAll("\n", "\r\n");
        KeyBundle keyBundle = (KeyBundle)this.keys.get(jID);
        if (keyBundle == null) {
            return;
        }
        Message message = null;
        try {
            literalMessageBuilder = LiteralMessageBuilder.getInstance((String)"OpenPGP");
            literalMessageBuilder.init(string2.getBytes());
            message = literalMessageBuilder.build();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("Cannot find the OpenPGP LiteralMessageBuilder. This usually means that the Cryptix OpenPGP provider is not installed correctly.");
            noSuchAlgorithmException.printStackTrace();
            return;
        }
        catch (MessageException messageException) {
            System.err.println("Reading the message failed.");
            messageException.printStackTrace();
            return;
        }
        literalMessageBuilder = null;
        try {
            MessageFactory messageFactory = MessageFactory.getInstance((String)"OpenPGP");
            byte[] byArray = PGPArmoury.unarmour((String)string);
            literalMessageBuilder = (PGPDetachedSignatureMessage)messageFactory.generateMessages((InputStream)new ByteArrayInputStream(byArray)).iterator().next();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("Cannot find the OpenPGP MessageFactory. This usually means that the Cryptix OpenPGP provider is not installed correctly.");
            noSuchAlgorithmException.printStackTrace();
            return;
        }
        catch (MessageException messageException) {
            System.err.println("Reading the message failed.");
            messageException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            System.err.println("Reading the message failed.");
            iOException.printStackTrace();
            return;
        }
        try {
            if (literalMessageBuilder.verify(message, keyBundle)) {
                System.out.println("Signature OK");
            } else {
                System.out.println("Signature BAD");
            }
        }
        catch (MessageException messageException) {
            System.err.println("Verifying the signature failed.");
            messageException.printStackTrace();
            return;
        }
        this.usesPGP.add(jID);
    }

    public boolean canEncrypt(JID jID) {
        return this.keys.containsKey(jID) && this.usesPGP.contains(jID);
    }

    public XExtension encrypt(String string, JID jID) {
        LiteralMessageBuilder literalMessageBuilder;
        KeyBundle keyBundle = (KeyBundle)this.keys.get(jID);
        if (keyBundle == null) {
            Popups.messagePopup((String)"Encryption not possible, key not found", (String)"Key not found");
            return null;
        }
        LiteralMessage literalMessage = null;
        try {
            literalMessageBuilder = LiteralMessageBuilder.getInstance((String)"OpenPGP");
            literalMessageBuilder.init(string.getBytes());
            literalMessage = (LiteralMessage)literalMessageBuilder.build();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("Cannot find the OpenPGP LiteralMessageBuilder. This usually means that the Cryptix OpenPGP provider is not installed correctly.");
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
        catch (MessageException messageException) {
            System.err.println("Creating the literal message failed.");
            messageException.printStackTrace();
            return null;
        }
        literalMessageBuilder = null;
        try {
            EncryptedMessageBuilder encryptedMessageBuilder = EncryptedMessageBuilder.getInstance((String)"OpenPGP");
            encryptedMessageBuilder.init((Message)literalMessage);
            encryptedMessageBuilder.addRecipient(keyBundle);
            encryptedMessageBuilder.setAttribute("compressed", (Object)"true");
            literalMessageBuilder = encryptedMessageBuilder.build();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("Cannot find the OpenPGP EncryptedMessageBuilder. This usually means that the Cryptix OpenPGP provider is not installed correctly.");
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
        catch (MessageException messageException) {
            System.err.println("Creating the encrypted message failed.");
            messageException.printStackTrace();
            return null;
        }
        try {
            return new XEncrypted(PGPArmoury.armour((byte[])literalMessageBuilder.getEncoded()));
        }
        catch (MessageException messageException) {
            System.err.println("Writing the encrypted message failed.");
            messageException.printStackTrace();
            return null;
        }
    }

    public String decrypt(Extension extension) {
        Collection collection;
        if (this.passpharse == null) {
            return null;
        }
        if (!(extension instanceof XEncrypted)) {
            return null;
        }
        System.out.println("decrypting....");
        String string = ((XEncrypted)extension).getCrypted();
        string = string.replaceAll("\n", "\r\n");
        MessageFactory messageFactory = null;
        try {
            messageFactory = MessageFactory.getInstance((String)"OpenPGP");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("Cannot find the OpenPGP MessageFactory. This usually means that the Cryptix OpenPGP provider is not installed correctly.");
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
        EncryptedMessage encryptedMessage = null;
        try {
            collection = messageFactory.generateMessages((InputStream)new ByteArrayInputStream(PGPArmoury.unarmour((String)string)));
            encryptedMessage = (EncryptedMessage)collection.iterator().next();
        }
        catch (IOException iOException) {
            System.err.println("IOException... You did remember to run the Encrypt example first, right?");
            iOException.printStackTrace();
            return null;
        }
        catch (MessageException messageException) {
            System.err.println("Reading message failed.");
            messageException.printStackTrace();
            return null;
        }
        try {
            collection = encryptedMessage.decrypt(this.secretKey, this.passpharse);
            System.out.println(((LiteralMessage)collection).getTextData());
            return ((LiteralMessage)collection).getTextData();
        }
        catch (NotEncryptedToParameterException notEncryptedToParameterException) {
            System.err.println("Not encrypted to this key.");
            notEncryptedToParameterException.printStackTrace();
            return null;
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            System.err.println("Invalid passphrase.");
            unrecoverableKeyException.printStackTrace();
            return null;
        }
        catch (MessageException messageException) {
            System.err.println("Decrypting message failed.");
            messageException.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ char[] access$002(Encrypter encrypter, char[] cArray) {
        encrypter.passpharse = cArray;
        return cArray;
    }
}

