/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pki;

import cryptix.pki.KeyBundleException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.Iterator;

public abstract class KeyBundle {
    private final String type;
    private transient int cachedHashCode = -1;

    protected KeyBundle(String type) {
        this.type = type;
    }

    public abstract boolean addCertificate(Certificate var1) throws KeyBundleException;

    public abstract boolean addPrincipal(Principal var1) throws KeyBundleException;

    public abstract boolean addPrivateKey(PrivateKey var1, PublicKey var2) throws KeyBundleException;

    public abstract boolean addPrivateKey(PrivateKey var1, PublicKey var2, char[] var3, SecureRandom var4) throws KeyBundleException;

    public abstract boolean addPublicKey(PublicKey var1) throws KeyBundleException;

    public abstract Object clone();

    public boolean equals(Object other) {
        try {
            byte[] thatBytes;
            if (!(other instanceof KeyBundle)) {
                return false;
            }
            KeyBundle that = (KeyBundle)other;
            if (this.hashCode() != that.hashCode()) {
                return false;
            }
            byte[] thisBytes = this.getEncoded();
            if (thisBytes.length != (thatBytes = that.getEncoded()).length) {
                return false;
            }
            int i = 0;
            while (i < thisBytes.length) {
                if (thisBytes[i] != thatBytes[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (KeyBundleException keyBundleException) {
            return false;
        }
    }

    public abstract Iterator getCertificates();

    public abstract Iterator getCertificates(PublicKey var1, Principal var2);

    public abstract byte[] getEncoded() throws KeyBundleException;

    public abstract Iterator getPrincipals();

    public abstract PrivateKey getPrivateKey(PublicKey var1, char[] var2) throws UnrecoverableKeyException;

    public abstract Iterator getPublicKeys();

    public final String getType() {
        return this.type;
    }

    public int hashCode() {
        if (this.cachedHashCode != -1) {
            return this.cachedHashCode;
        }
        try {
            byte[] thisBytes = this.getEncoded();
            int hash = 0;
            int i = 0;
            while (i < thisBytes.length) {
                hash = (hash << 7 | hash >>> 25) ^ thisBytes[i] & 0xFF;
                ++i;
            }
            this.cachedHashCode = hash;
            return this.cachedHashCode;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
        catch (KeyBundleException keyBundleException) {
            return 0;
        }
    }

    public abstract boolean removeCertificate(Certificate var1) throws KeyBundleException;

    public abstract boolean removePrincipal(Principal var1) throws KeyBundleException;

    public abstract boolean removePrivateKey(PublicKey var1) throws KeyBundleException;

    public abstract boolean removePublicKey(PublicKey var1) throws KeyBundleException;
}

