/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.signature;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.io.PGPSignatureDataInputStream;
import cryptix.openpgp.io.PGPSignatureDataOutputStream;
import cryptix.openpgp.signature.PGPSignatureSubPacket;
import cryptix.openpgp.util.PGPCompare;
import java.io.IOException;

public class PGPTrustSP
extends PGPSignatureSubPacket {
    public static final byte NO_TRUST = 0;
    public static final byte PARTIAL_TRUST = 60;
    public static final byte FULL_TRUST = 120;
    public static final byte NORMAL_SIGNATURE = 0;
    public static final byte TRUSTED_INTRODUCER = 1;
    public static final byte META_INTRODUCER = 2;
    private byte depth = 0;
    private byte amount = 0;

    protected void decodeBody(PGPSignatureDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        this.setDepth(in.readByte());
        this.setAmount(in.readByte());
    }

    protected void encodeBody(PGPSignatureDataOutputStream out) throws IOException {
        out.writeByte(this.getDepth());
        out.writeByte(this.getAmount());
    }

    public boolean equals(Object ssp) {
        if (!(ssp instanceof PGPTrustSP)) {
            return false;
        }
        PGPTrustSP that = (PGPTrustSP)ssp;
        return PGPCompare.equals(this.getPacketID(), that.getPacketID()) && PGPCompare.equals(this.getDepth(), that.getDepth()) && PGPCompare.equals(this.getAmount(), that.getAmount());
    }

    public byte getAmount() {
        return this.amount;
    }

    public byte getDepth() {
        return this.depth;
    }

    public void setAmount(byte amount) {
        this.amount = amount;
    }

    public void setDepth(byte depth) {
        this.depth = depth;
    }
}

