/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.provider;

import cryptix.openpgp.PGPKeyRingCertStoreParameters;
import cryptix.openpgp.provider.PGPKeyBundleFactory;
import cryptix.pki.ExtendedCertStoreSpi;
import cryptix.pki.KeyBundle;
import cryptix.pki.KeyBundleException;
import cryptix.pki.KeyBundleSelector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class PGPKeyRingCertStore
extends ExtendedCertStoreSpi {
    private File file;
    private Vector bundles;

    public PGPKeyRingCertStore(CertStoreParameters params) throws InvalidAlgorithmParameterException {
        super(params);
        if (params == null) {
            throw new InvalidAlgorithmParameterException("Null parameters not supported.");
        }
        if (!(params instanceof PGPKeyRingCertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("Instance of cryptix.openpgp.PGPKeyRingCertStoreParameters expected.");
        }
        this.file = ((PGPKeyRingCertStoreParameters)params).getFile();
        try {
            FileInputStream in = new FileInputStream(this.file);
            this.bundles = (Vector)PGPKeyBundleFactory.helper(in, false);
        }
        catch (IOException ioe) {
            throw new InvalidAlgorithmParameterException("Error while reading keyring - " + ioe);
        }
        catch (KeyBundleException kbe) {
            throw new InvalidAlgorithmParameterException("Error while reading keyring - " + (Object)((Object)kbe));
        }
    }

    public Collection engineGetCRLs(CRLSelector selector) throws CertStoreException {
        throw new RuntimeException("NYI");
    }

    public Collection engineGetCertificates(CertSelector selector) throws CertStoreException {
        Vector<Certificate> result = new Vector<Certificate>();
        Iterator it = ((AbstractList)this.bundles).iterator();
        while (it.hasNext()) {
            KeyBundle bundle = (KeyBundle)it.next();
            Iterator it2 = bundle.getCertificates();
            while (it2.hasNext()) {
                Certificate cert = (Certificate)it2.next();
                if (selector == null) {
                    result.add(cert);
                    continue;
                }
                if (!selector.match(cert)) continue;
                result.add(cert);
            }
        }
        return result;
    }

    public Collection engineGetKeyBundles(KeyBundleSelector selector) throws CertStoreException {
        if (selector == null) {
            return (Vector)this.bundles.clone();
        }
        Vector<KeyBundle> result = new Vector<KeyBundle>();
        Iterator it = ((AbstractList)this.bundles).iterator();
        while (it.hasNext()) {
            KeyBundle bundle = (KeyBundle)it.next();
            if (!selector.match(bundle)) continue;
            result.add(bundle);
        }
        return result;
    }

    public void engineSetKeyBundleEntry(KeyBundle bundle) throws CertStoreException {
        this.bundles.add(bundle);
        try {
            FileOutputStream out = new FileOutputStream(this.file);
            Iterator it = ((AbstractList)this.bundles).iterator();
            while (it.hasNext()) {
                KeyBundle temp = (KeyBundle)it.next();
                out.write(temp.getEncoded());
            }
        }
        catch (IOException ioe) {
            throw new CertStoreException("Error while writing keyring - " + ioe);
        }
        catch (KeyBundleException kbe) {
            throw new CertStoreException("Error while writing keyring - " + (Object)((Object)kbe));
        }
    }
}

