/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.provider;

import cryptix.message.Message;
import cryptix.message.MessageException;
import cryptix.openpgp.PGPDetachedSignatureMessage;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.packet.PGPSignaturePacket;
import cryptix.openpgp.provider.PGPLiteralMessageImpl;
import cryptix.openpgp.provider.PGPSignedMessageImpl;
import cryptix.pki.KeyBundle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.PublicKey;

public class PGPDetachedSignatureMessageImpl
extends PGPDetachedSignatureMessage {
    private final PGPSignaturePacket pkt;

    protected PGPDetachedSignatureMessageImpl(PGPSignaturePacket pkt) {
        super("OpenPGP");
        this.pkt = pkt;
    }

    public Object getAttribute(String name) throws IllegalArgumentException, MessageException {
        if (!name.equals("Hash")) {
            throw new IllegalArgumentException("Not supported.");
        }
        PGPAlgorithmFactory factory = PGPAlgorithmFactory.getDefaultInstance();
        return factory.getHashTextName(this.pkt.getHashID());
    }

    public byte[] getEncoded() throws MessageException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.pkt.encode(baos);
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException("IOException in ByteArrayOutputStream - " + ioe);
        }
    }

    public PGPSignaturePacket getPacket() {
        return this.pkt;
    }

    public boolean verify(Message msg, KeyBundle pubkey) throws MessageException {
        return this.verify(msg, (PublicKey)pubkey.getPublicKeys().next());
    }

    public boolean verify(Message msg, PublicKey pubkey) throws MessageException {
        if (!(msg instanceof PGPLiteralMessageImpl)) {
            throw new IllegalArgumentException("Not a PGP LiteralMessage.");
        }
        PGPSignedMessageImpl sm = new PGPSignedMessageImpl(false, this.pkt, (PGPLiteralMessageImpl)msg);
        return sm.verify(pubkey);
    }
}

