/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.packet;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.io.PGPPacketDataInputStream;
import cryptix.openpgp.packet.PGPPacket;
import cryptix.openpgp.packet.PGPUnknownPacket;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class PGPPacketFactory {
    public static final int INIT_DEFAULT = 0;
    public static final int INIT_EMPTY_ALL = 255;
    public static final int INIT_EMPTY = 255;
    private Hashtable PacketClasses = new Hashtable();
    private static final int[] defaultPacketIDs = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 18, 19};
    private static final String[] defaultPacketClasses = new String[]{"cryptix.openpgp.packet.PGPPublicKeyEncryptedSessionKeyPacket", "cryptix.openpgp.packet.PGPSignaturePacket", "cryptix.openpgp.packet.PGPSymmetricKeyEncryptedSessionKeyPacket", "cryptix.openpgp.packet.PGPOnePassSignaturePacket", "cryptix.openpgp.packet.PGPSecretKeyPacket", "cryptix.openpgp.packet.PGPPublicKeyPacket", "cryptix.openpgp.packet.PGPSecretSubKeyPacket", "cryptix.openpgp.packet.PGPCompressedDataPacket", "cryptix.openpgp.packet.PGPSymmetricallyEncryptedDataPacket", "cryptix.openpgp.packet.PGPMarkerPacket", "cryptix.openpgp.packet.PGPLiteralDataPacket", "cryptix.openpgp.packet.PGPTrustPacket", "cryptix.openpgp.packet.PGPUserIDPacket", "cryptix.openpgp.packet.PGPPublicSubKeyPacket", "cryptix.openpgp.packet.PGPSymmetricallyEncryptedIntegrityProtectedDataPacket", "cryptix.openpgp.packet.PGPModificationDetectionCodePacket"};
    private static PGPPacketFactory defaultInstance = null;

    public PGPPacketFactory() {
        this(0);
    }

    public PGPPacketFactory(int init) {
        if ((init & 0xFF) == 0) {
            this.DefaultPackets();
        }
    }

    private void DefaultPackets() {
        int i = 0;
        while (i < defaultPacketIDs.length) {
            this.registerPacket(defaultPacketIDs[i], defaultPacketClasses[i]);
            ++i;
        }
    }

    public static PGPPacketFactory getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new PGPPacketFactory(0);
        }
        return defaultInstance;
    }

    public PGPPacket getPacket(int id) {
        try {
            String classname = (String)this.PacketClasses.get(new Integer(id));
            if (classname == null) {
                PGPUnknownPacket packet = new PGPUnknownPacket();
                packet.setPacketID((byte)id);
                return packet;
            }
            Class<?> cl = Class.forName(classname);
            PGPPacket packet = (PGPPacket)cl.newInstance();
            packet.setPacketID((byte)id);
            return packet;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Packet #" + id + " cannot be loaded.");
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("Packet #" + id + " cannot be loaded.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Packet #" + id + " cannot be loaded.");
        }
    }

    public PGPPacket readPacket(InputStream in, PGPAlgorithmFactory factory) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        int len;
        boolean old;
        int id;
        int type;
        try {
            type = in.read();
        }
        catch (IOException ioe) {
            throw new IOException("Error reading packet type: " + ioe.toString());
        }
        if (type < 128) {
            throw new PGPFatalDataFormatException("Invalid packet type.");
        }
        if (type >= 192) {
            id = type & 0x3F;
            old = false;
            len = -1;
        } else {
            id = type >> 2 & 0xF;
            old = true;
            len = type & 3;
        }
        PGPPacket packet = this.getPacket(id);
        PGPPacketDataInputStream pin = new PGPPacketDataInputStream(in, old, len);
        packet.decodeBody(pin, factory);
        return packet;
    }

    public void registerPacket(int id, String classname) {
        this.PacketClasses.put(new Integer(id), classname);
    }

    public void unregisterPacket(int id) {
        this.PacketClasses.remove(new Integer(id));
    }
}

