/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.packet;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPDecryptionFailedException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.io.PGPPacketDataInputStream;
import cryptix.openpgp.io.PGPPacketDataOutputStream;
import cryptix.openpgp.packet.PGPContainerPacket;
import cryptix.openpgp.packet.PGPSessionKey;
import cryptix.openpgp.util.PGPCompare;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class PGPEncryptedDataPacket
extends PGPContainerPacket {
    private byte[] encrypted;
    private byte[] decrypted;
    private boolean mdc;

    protected PGPEncryptedDataPacket(boolean mdc) {
        this.mdc = mdc;
    }

    public void decodeBody(PGPPacketDataInputStream in, PGPAlgorithmFactory factory) throws IOException, PGPFatalDataFormatException, PGPDataFormatException {
        if (this.mdc && in.readByte() != 1) {
            in.readByteArray();
            throw new PGPDataFormatException("Invalid version for integrity protected encrypted data packet.");
        }
        this.encrypted = in.readByteArray();
    }

    public void decrypt(PGPSessionKey[] sessionkeys, PGPAlgorithmFactory factory) throws PGPDecryptionFailedException, PGPDataFormatException, PGPFatalDataFormatException {
        byte[] prefix;
        IvParameterSpec ivspec;
        int j;
        byte[] iv;
        if (this.decrypted != null) {
            return;
        }
        byte[] correctkey = null;
        int correctid = 0;
        int i = 0;
        while (i < sessionkeys.length) {
            byte[] key = sessionkeys[i].getBytes();
            boolean failed = false;
            byte id = sessionkeys[i].getCipherID();
            int blocksize = 0;
            int keysize = 0;
            try {
                blocksize = factory.getCipherBlockSize(id);
                keysize = factory.getCipherKeySize(id);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                failed = true;
            }
            if (!failed && key.length == keysize) {
                byte[] prefix2;
                Cipher cp;
                iv = new byte[blocksize];
                j = 0;
                while (j < iv.length) {
                    iv[j] = 0;
                    ++j;
                }
                ivspec = new IvParameterSpec(iv);
                byte[] prefixcrypt = new byte[blocksize * 2 + 2];
                System.arraycopy(this.encrypted, 0, prefixcrypt, 0, blocksize * 2 + 2);
                try {
                    cp = factory.getCipherAlgorithm(id, "CFB");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new RuntimeException("Inconsistency in factory: factory.getCipherBlockSize(id) and .getCipherKeySize(id) succeeded, but factory.getCipherAlgorithm(id) did not.");
                }
                StringTokenizer st = new StringTokenizer(cp.getAlgorithm(), "/");
                SecretKeySpec keyspec = new SecretKeySpec(key, st.nextToken());
                try {
                    cp.init(2, (Key)keyspec, ivspec);
                }
                catch (InvalidKeyException ike) {
                    ike.printStackTrace();
                    throw new InternalError("InvalidKeyException on decrypting a key - " + ike);
                }
                catch (InvalidAlgorithmParameterException iape) {
                    iape.printStackTrace();
                    throw new InternalError("InvalidAlgorithmParameterException on decrypting a key - " + iape);
                }
                try {
                    prefix2 = cp.doFinal(prefixcrypt);
                }
                catch (BadPaddingException bpe) {
                    bpe.printStackTrace();
                    throw new InternalError("Hmm... got a BadPaddingException while we are not even using padding.");
                }
                catch (IllegalBlockSizeException illegalBlockSizeException) {
                    throw new RuntimeException("Inconsistency between blocksize in factory and blocksize in cipher.");
                }
                if (prefix2[blocksize - 2] == prefix2[blocksize] && prefix2[blocksize - 1] == prefix2[blocksize + 1]) {
                    if (correctkey != null && !PGPCompare.equals(correctkey, key)) {
                        throw new PGPDecryptionFailedException("Two different session keys have passed the test. It is therefore impossible to determine which one to use and thus impossible to correctly decrypt the data.");
                    }
                    correctkey = key;
                    correctid = id;
                }
            }
            ++i;
        }
        if (correctkey == null) {
            correctid = 7;
            correctkey = new byte[16];
        }
        int blocksize = 0;
        int keysize = 0;
        Cipher cp = null;
        try {
            blocksize = factory.getCipherBlockSize(correctid);
            keysize = factory.getCipherBlockSize(correctid);
            cp = this.mdc ? factory.getCipherAlgorithm(correctid, "CFB") : factory.getCipherAlgorithm(correctid, "OpenpgpCFB");
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
            throw new InternalError("PANIC");
        }
        StringTokenizer st = new StringTokenizer(cp.getAlgorithm(), "/");
        SecretKeySpec keyspec = new SecretKeySpec(correctkey, st.nextToken());
        iv = new byte[blocksize];
        j = 0;
        while (j < iv.length) {
            iv[j] = 0;
            ++j;
        }
        ivspec = new IvParameterSpec(iv);
        try {
            cp.init(2, (Key)keyspec, ivspec);
        }
        catch (InvalidKeyException ike) {
            ike.printStackTrace();
            throw new InternalError("InvalidKeyException on decrypting a key - " + ike);
        }
        catch (InvalidAlgorithmParameterException iape) {
            iape.printStackTrace();
            throw new InternalError("InvalidAlgorithmParameterException on decrypting a key - " + iape);
        }
        try {
            int ps = blocksize + 2;
            byte[] result = cp.doFinal(this.encrypted);
            prefix = new byte[ps];
            this.decrypted = new byte[result.length - ps];
            System.arraycopy(result, 0, prefix, 0, ps);
            System.arraycopy(result, ps, this.decrypted, 0, this.decrypted.length);
        }
        catch (IllegalBlockSizeException ibse) {
            ibse.printStackTrace();
            throw new InternalError("Should not happen on CFB mode. " + ibse);
        }
        catch (BadPaddingException bpe) {
            bpe.printStackTrace();
            throw new InternalError("Should not happen on CFB mode. " + bpe);
        }
        if (this.mdc) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-1");
                md.update(prefix);
                md.update(this.decrypted, 0, this.decrypted.length - 20);
                byte[] hash = md.digest();
                if (this.decrypted[this.decrypted.length - 22] != -48 && this.decrypted[this.decrypted.length - 21] != 20) {
                    throw new PGPDataFormatException("MDC packet missing or invalid");
                }
                int i2 = 0;
                while (i2 < 20) {
                    if (hash[i2] != this.decrypted[this.decrypted.length - 20 + i2]) {
                        throw new PGPDataFormatException("Invalid hash in MDC packet. The message has potentially been tampered with.");
                    }
                    ++i2;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("SHA-1 hash not found.");
            }
        }
        try {
            ByteArrayInputStream bais = this.mdc ? new ByteArrayInputStream(this.decrypted, 0, this.decrypted.length - 22) : new ByteArrayInputStream(this.decrypted);
            this.decodeSubPackets(bais, factory);
            bais.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException("IOException on ByteArrayInputStream, should not happen. " + ioe);
        }
    }

    public void encodeBody(PGPPacketDataOutputStream out) throws IOException {
        if (this.mdc) {
            out.writeByte((byte)1);
        }
        out.writeFully(this.encrypted);
    }

    public void encrypt(byte[] key, int cipherid, PGPAlgorithmFactory factory, SecureRandom sr) {
        if (this.encrypted != null) {
            return;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.encodeSubPackets(baos);
            baos.close();
            this.decrypted = baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException("IOException on ByteArrayOutputStream - " + ioe);
        }
        int blocksize = 0;
        int keysize = 0;
        Cipher cp = null;
        try {
            blocksize = factory.getCipherBlockSize(cipherid);
            keysize = factory.getCipherBlockSize(cipherid);
            cp = this.mdc ? factory.getCipherAlgorithm(cipherid, "CFB") : factory.getCipherAlgorithm(cipherid, "OpenpgpCFB");
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
            throw new InternalError("PANIC");
        }
        StringTokenizer st = new StringTokenizer(cp.getAlgorithm(), "/");
        SecretKeySpec keyspec = new SecretKeySpec(key, st.nextToken());
        byte[] iv = new byte[blocksize];
        int j = 0;
        while (j < iv.length) {
            iv[j] = 0;
            ++j;
        }
        IvParameterSpec ivspec = new IvParameterSpec(iv);
        try {
            cp.init(1, (Key)keyspec, ivspec);
        }
        catch (InvalidKeyException ike) {
            ike.printStackTrace();
            throw new InternalError("InvalidKeyException on encrypting a key - " + ike);
        }
        catch (InvalidAlgorithmParameterException iape) {
            iape.printStackTrace();
            throw new InternalError("InvalidAlgorithmParameterException on encrypting a key - " + iape);
        }
        byte[] prefix = new byte[blocksize];
        byte[] repeat = new byte[2];
        sr.nextBytes(prefix);
        repeat[0] = prefix[prefix.length - 2];
        repeat[1] = prefix[prefix.length - 1];
        byte[] mdcsuffix = null;
        if (this.mdc) {
            try {
                mdcsuffix = new byte[22];
                mdcsuffix[0] = -48;
                mdcsuffix[1] = 20;
                MessageDigest md = MessageDigest.getInstance("SHA-1");
                md.update(prefix);
                md.update(repeat);
                md.update(this.decrypted);
                byte[] mdcheader = new byte[]{-48, 20};
                md.update(mdcheader);
                byte[] hash = md.digest();
                int i = 0;
                while (i < 20) {
                    mdcsuffix[i + 2] = hash[i];
                    ++i;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("SHA-1 hash not found.");
            }
        }
        byte[] alldata = mdcsuffix == null ? new byte[blocksize + 2 + this.decrypted.length] : new byte[blocksize + 2 + this.decrypted.length + 22];
        System.arraycopy(prefix, 0, alldata, 0, blocksize);
        System.arraycopy(repeat, 0, alldata, blocksize, 2);
        System.arraycopy(this.decrypted, 0, alldata, 2 + blocksize, this.decrypted.length);
        if (mdcsuffix != null) {
            System.arraycopy(mdcsuffix, 0, alldata, alldata.length - 22, 22);
        }
        try {
            this.encrypted = cp.doFinal(alldata);
        }
        catch (IllegalBlockSizeException ibse) {
            ibse.printStackTrace();
            throw new InternalError("Should not happen on CFB mode. " + ibse);
        }
        catch (BadPaddingException bpe) {
            bpe.printStackTrace();
            throw new InternalError("Should not happen on CFB mode. " + bpe);
        }
    }
}

