/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.net;

import cryptix.openpgp.net.EmptyIterator;
import cryptix.openpgp.net.KeyServerIOException;
import cryptix.openpgp.net.PGPKeyServerImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Hkp
extends PGPKeyServerImpl {
    private static final String START_TAG = "-----BEGIN PGP PUBLIC KEY BLOCK-----";
    private static final String END_TAG = "-----END PGP PUBLIC KEY BLOCK-----";
    private static final String CR = "\n";
    private String host;
    private int port;

    public Hkp(String servername, int port) throws NoSuchAlgorithmException {
        super("OpenPGP");
        this.host = servername;
        this.port = port;
    }

    public Iterator fetchRaw(String id) throws KeyServerIOException {
        List keys = null;
        try {
            URL url = new URL("http", this.host, this.port, "/pks/lookup?op=get&search=" + URLEncoder.encode(id));
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.connect();
            if (con.getResponseCode() != 200) {
                throw new KeyServerIOException(this.host, this.port, "Server did not return HTTP_OK!" + con.getResponseMessage());
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            keys = this.parseResponse(in);
            in.close();
            con.disconnect();
        }
        catch (MalformedURLException e) {
            throw new KeyServerIOException(this.host, this.port, String.valueOf(e.getClass().getName()) + ": " + e.getMessage());
        }
        catch (IOException e) {
            throw new KeyServerIOException(this.host, this.port, String.valueOf(e.getClass().getName()) + ": " + e.getMessage());
        }
        if (keys != null) {
            return keys.iterator();
        }
        return new EmptyIterator();
    }

    private List parseResponse(BufferedReader in) throws IOException {
        ArrayList<String> keys = new ArrayList<String>();
        String line = null;
        StringBuffer buf = new StringBuffer();
        boolean seekStart = true;
        while ((line = in.readLine()) != null) {
            if (seekStart && line.startsWith(START_TAG)) {
                seekStart = false;
                buf.append(line).append(CR);
                continue;
            }
            if (!seekStart && line.startsWith(END_TAG)) {
                seekStart = true;
                buf.append(line).append(CR);
                keys.add(buf.toString());
                buf.setLength(0);
                continue;
            }
            if (seekStart) continue;
            buf.append(line).append(CR);
        }
        return keys;
    }
}

