/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.io;

import cryptix.openpgp.io.PGPLengthDataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PGPPacketDataOutputStream
extends PGPLengthDataOutputStream {
    private byte packetID;
    private boolean partial = false;
    private int forcetype = -1;
    private static final long[] powtwo = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L};

    public PGPPacketDataOutputStream(OutputStream out, byte packetID) {
        super(out);
        this.packetID = packetID;
        this.forcetype = -1;
    }

    public PGPPacketDataOutputStream(OutputStream out, byte packetID, int forcetype) {
        super(out);
        this.packetID = packetID;
        this.forcetype = forcetype;
    }

    protected void writeLength(OutputStream out, long len) throws IOException {
        if (!this.partial) {
            if (this.packetID < 16) {
                this.writeOldTypeAndLength(out, this.packetID, len);
            } else {
                this.writeNewType(out, this.packetID);
                this.writeNewLength(out, len);
            }
        } else {
            this.writeNewLength(out, len);
        }
    }

    private void writeNewLength(OutputStream out, long len) throws IOException {
        if (len < 0L) {
            throw new IllegalArgumentException("Negative length not allowed");
        }
        if (len < 192L) {
            out.write((byte)len);
        } else if (len < 8384L) {
            out.write(192 + (byte)(len - 192L >> 8));
            out.write((byte)(len - 192L));
        } else if (len < 0x100000000L) {
            out.write(255);
            out.write((byte)(len >> 24));
            out.write((byte)(len >> 16));
            out.write((byte)(len >> 8));
            out.write((byte)len);
        } else {
            throw new IllegalArgumentException("Maximum length exceeded");
        }
    }

    private void writeNewPartialLength(OutputStream out, long len) throws IOException {
        int i = 0;
        while (i < powtwo.length) {
            if (powtwo[i] == len) {
                out.write(224 + i);
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException("Partial length is not a power of two between 2^0 and 2^30");
    }

    private void writeNewType(OutputStream out, byte type) throws IOException {
        if (type >= 64 || type < 0) {
            throw new IllegalArgumentException("Packet ID should be 0<=id<=63");
        }
        out.write(192 + type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeOldTypeAndLength(OutputStream out, byte type, long len) throws IOException {
        int lentype;
        if (len < 0L) {
            throw new IllegalArgumentException("Negative length not allowed");
        }
        if (this.forcetype == -1) {
            if (len < 256L) {
                lentype = 0;
            } else if (len < 65536L) {
                lentype = 1;
            } else {
                if (len >= 0x100000000L) throw new IllegalArgumentException("Maximum length exceeded");
                lentype = 2;
            }
        } else {
            if (this.forcetype > 2 || this.forcetype < 0) {
                throw new IllegalArgumentException("Invalid forced length " + this.forcetype);
            }
            lentype = this.forcetype;
        }
        out.write(128 + (type << 2) + lentype);
        if (lentype == 0) {
            out.write((byte)len);
            return;
        } else if (lentype == 1) {
            out.write((byte)(len >> 8));
            out.write((byte)len);
            return;
        } else {
            out.write((byte)(len >> 24));
            out.write((byte)(len >> 16));
            out.write((byte)(len >> 8));
            out.write((byte)len);
        }
    }

    protected void writePartialLength(OutputStream out, long len) throws IOException {
        if (!this.partial) {
            this.writeNewType(out, this.packetID);
            this.partial = true;
        }
        this.writeNewPartialLength(out, len);
    }
}

