/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp;

import cryptix.openpgp.PGPSignatureParameterSpec;
import cryptix.openpgp.signature.PGPDateSP;
import cryptix.openpgp.signature.PGPKeyIDSP;
import cryptix.openpgp.signature.PGPSignatureSubPacket;
import cryptix.pki.KeyID;
import cryptix.pki.KeyIDFactory;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public abstract class PGPAbstractSignatureParameterBuilder {
    private Vector hashed;
    private Vector unhashed;
    private byte sigtype;

    protected PGPAbstractSignatureParameterBuilder(KeyID issuerkeyid, byte sigtype) {
        this.init(issuerkeyid, sigtype);
    }

    protected PGPAbstractSignatureParameterBuilder(Key issuerkey, byte sigtype) throws InvalidKeyException {
        KeyID issuerkeyid;
        try {
            issuerkeyid = KeyIDFactory.getInstance((String)"OpenPGP").generateKeyID(issuerkey);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException("Could not get KeyIDFactory for OpenPGP");
        }
        this.init(issuerkeyid, sigtype);
    }

    public void addPacket(PGPSignatureSubPacket ssp) {
        this.hashed.addElement(ssp);
    }

    public void addUnhashedPacket(PGPSignatureSubPacket ssp) {
        this.unhashed.addElement(ssp);
    }

    public AlgorithmParameterSpec build() {
        return new PGPSignatureParameterSpec(this.hashed, this.unhashed, this.sigtype);
    }

    private void init(KeyID issuerkeyid, byte sigtype) {
        this.sigtype = sigtype;
        this.hashed = new Vector();
        this.unhashed = new Vector();
        PGPDateSP creation = new PGPDateSP();
        creation.setValue(new Date());
        creation.setPacketID((byte)2);
        this.hashed.addElement(creation);
        PGPKeyIDSP keyid = new PGPKeyIDSP();
        keyid.setValue(issuerkeyid.getBytes(8));
        keyid.setPacketID((byte)16);
        this.unhashed.addElement(keyid);
    }

    public PGPSignatureSubPacket removePacket(byte packetid) {
        Enumeration em = this.hashed.elements();
        while (em.hasMoreElements()) {
            PGPSignatureSubPacket tmp = (PGPSignatureSubPacket)em.nextElement();
            if (tmp.getPacketID() != packetid) continue;
            this.hashed.removeElement(tmp);
            return tmp;
        }
        return null;
    }

    public PGPSignatureSubPacket removeUnhashedPacket(byte packetid) {
        Enumeration em = this.unhashed.elements();
        while (em.hasMoreElements()) {
            PGPSignatureSubPacket tmp = (PGPSignatureSubPacket)em.nextElement();
            if (tmp.getPacketID() != packetid) continue;
            this.unhashed.removeElement(tmp);
            return tmp;
        }
        return null;
    }

    public void setCreationDate(Date creation) {
        PGPDateSP pkt = new PGPDateSP();
        pkt.setValue(creation);
        pkt.setPacketID((byte)2);
        this.setPacket(pkt);
    }

    public void setIssuerKeyID(KeyID issuerkeyid) {
        PGPKeyIDSP pkt = new PGPKeyIDSP();
        pkt.setValue(issuerkeyid.getBytes(8));
        pkt.setPacketID((byte)16);
        this.setUnhashedPacket(pkt);
    }

    public PGPSignatureSubPacket setPacket(PGPSignatureSubPacket ssp) {
        Enumeration em = this.hashed.elements();
        while (em.hasMoreElements()) {
            PGPSignatureSubPacket tmp = (PGPSignatureSubPacket)em.nextElement();
            if (tmp.getPacketID() != ssp.getPacketID()) continue;
            int i = this.hashed.indexOf(tmp);
            this.hashed.removeElementAt(i);
            this.hashed.insertElementAt(ssp, i);
            return tmp;
        }
        this.hashed.addElement(ssp);
        return null;
    }

    public void setSignatureType(byte sigtype) {
        this.sigtype = sigtype;
    }

    public PGPSignatureSubPacket setUnhashedPacket(PGPSignatureSubPacket ssp) {
        Enumeration em = this.unhashed.elements();
        while (em.hasMoreElements()) {
            PGPSignatureSubPacket tmp = (PGPSignatureSubPacket)em.nextElement();
            if (tmp.getPacketID() != ssp.getPacketID()) continue;
            int i = this.unhashed.indexOf(tmp);
            this.unhashed.removeElementAt(i);
            this.unhashed.insertElementAt(ssp, i);
            return tmp;
        }
        this.unhashed.addElement(ssp);
        return null;
    }

    public void updateCreationDate() {
        this.setCreationDate(new Date());
    }
}

