/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.ui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.ImageIcon;
import nu.fw.jeti.plugins.drawing.shapes.PictureChat;
import nu.fw.jeti.plugins.drawing.shapes.TextShape;
import nu.fw.jeti.plugins.drawing.ui.Board;
import nu.fw.jeti.plugins.drawing.ui.Mode;

public class WritingMode
extends Mode {
    public WritingMode(PictureChat pictureChat, Board board, String string, ImageIcon imageIcon, String string2, Integer n) {
        super(pictureChat, board, string, imageIcon, string2, n);
    }

    public void dispose() {
        if (this.board.getCurrentShape() instanceof TextShape) {
            this.stopEditing();
        }
        super.dispose();
    }

    public void mouseClicked(MouseEvent mouseEvent, Color color, Point2D.Double double_, int n, int n2) {
        TextShape textShape;
        this.chat.unselect();
        if (mouseEvent.getClickCount() >= 2 && (textShape = this.chat.getClickedTextShape(double_, n, n2)) != null) {
            this.board.setCurrentShape(textShape);
            this.startEditing(textShape, n, n2);
            return;
        }
        if (this.board.getCurrentShape() == null) {
            textShape = new TextShape(this.chat.getMyJID(), this.board.getFontForegroundColor(), this.board.getCurrentFont(), double_);
            this.startEditing(textShape, n, n2);
        } else if (this.board.getCurrentShape() instanceof TextShape && !this.board.getCurrentShape().isPointInShapesInterior(double_, n, n2)) {
            this.stopEditing();
        }
        this.board.repaint();
    }

    private void startEditing(TextShape textShape, int n, int n2) {
        textShape.startEditing();
        textShape.getTextField(this.board.getGraphics(), n, n2).addActionListener(new EnterListener());
        this.board.addTextField(textShape.getTextField(this.board.getGraphics(), n, n2));
        this.board.setCurrentShape(textShape);
    }

    private void stopEditing() {
        if (this.board.getCurrentShape() != null) {
            ((TextShape)this.board.getCurrentShape()).stopEditing();
            if (!((TextShape)this.board.getCurrentShape()).isEmptyText()) {
                this.chat.draw(this.board.getCurrentShape());
            }
            this.board.setCurrentShape(null);
        }
    }

    class EnterListener
    implements ActionListener {
        EnterListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WritingMode.this.stopEditing();
        }
    }
}

