/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nu.fw.jeti.plugins.drawing.ui.Board;
import nu.fw.jeti.plugins.drawing.ui.PictureChatFrame;
import nu.fw.jeti.util.I18N;

public class TransparencySettingAction
extends AbstractAction
implements ChangeListener {
    private static final long serialVersionUID = 363618513140706658L;
    private Board board;
    private PictureChatFrame frame;
    public static final int TRANS_MIN = 0;
    public static final int TRANS_MAX = 255;

    public TransparencySettingAction(String string, ImageIcon imageIcon, String string2, Integer n, PictureChatFrame pictureChatFrame, Board board) {
        super(string, imageIcon);
        this.frame = pictureChatFrame;
        this.board = board;
        this.putValue("ShortDescription", string2);
        this.putValue("MnemonicKey", n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JDialog jDialog = new JDialog((Frame)this.frame, I18N.getText((String)"drawing", (String)"Choose_transparency"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(I18N.getText((String)"drawing", (String)"Choose_the_transparency_of_the_future_colors"));
        JSlider jSlider = this.createSlider();
        jSlider.setPreferredSize(new Dimension(200, 80));
        jSlider.setVisible(true);
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jSlider, "Center");
        jPanel.setBorder(BorderFactory.createEtchedBorder(1));
        jDialog.getContentPane().add(jPanel);
        jDialog.pack();
        jDialog.setModal(true);
        jDialog.setVisible(true);
        jDialog.setLocationRelativeTo(this.frame);
    }

    private JSlider createSlider() {
        JSlider jSlider = new JSlider(0, 0, 255, this.board.getCurrentTransparency());
        jSlider.addChangeListener(this);
        jSlider.setMajorTickSpacing(85);
        jSlider.setMinorTickSpacing(17);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(0), new JLabel(I18N.getText((String)"drawing", (String)"Transparent")));
        hashtable.put(new Integer(255), new JLabel(I18N.getText((String)"drawing", (String)"Opaque")));
        jSlider.setLabelTable(hashtable);
        jSlider.setPaintTicks(true);
        jSlider.setPaintLabels(true);
        return jSlider;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (!jSlider.getValueIsAdjusting()) {
            int n = jSlider.getValue();
            this.board.setCurrentTransparency(n);
        }
    }
}

