/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.ui;

import java.awt.Color;
import java.awt.geom.Point2D;
import javax.swing.ImageIcon;
import nu.fw.jeti.plugins.drawing.geometry.PointsOperations;
import nu.fw.jeti.plugins.drawing.geometry.Vector;
import nu.fw.jeti.plugins.drawing.shapes.PictureChat;
import nu.fw.jeti.plugins.drawing.shapes.Rectangle;
import nu.fw.jeti.plugins.drawing.ui.Board;
import nu.fw.jeti.plugins.drawing.ui.Mode;

public class SelectionMode
extends Mode {
    private boolean isFilled = true;
    private boolean isMoving = false;

    public SelectionMode(PictureChat pictureChat, Board board, String string, ImageIcon imageIcon, String string2, Integer n) {
        super(pictureChat, board, string, imageIcon, string2, n);
    }

    public void dispose() {
        super.dispose();
        this.isMoving = false;
    }

    public void mousePressed(Point2D.Double double_, Color color, int n, int n2) {
        super.mousePressed(double_, color, n, n2);
        this.color = this.board.getSelectionBackgroundColor();
        this.isMoving = this.chat.checkIfClickedInSelection(double_, n, n2);
        this.end = this.start;
    }

    public void mouseReleased(Point2D.Double double_, int n, int n2) {
        if (this.isMoving) {
            this.chat.moveShapes(new Vector(this.end, double_));
            this.end = double_;
            Vector vector = new Vector(this.start, this.end);
            this.chat.moveShapes(vector.getReverseVector());
            this.chat.sendShapesTranslation(vector);
        } else {
            this.end = double_;
            if (this.start.x == this.end.x && this.start.y == this.end.y) {
                this.chat.selectItem(this.start, n, n2);
            } else {
                this.chat.selectItems(this.start, this.end);
            }
        }
        this.board.setCurrentShape(null);
    }

    public void mouseDragged(Point2D.Double double_) {
        if (this.isMoving) {
            this.chat.moveShapes(new Vector(this.end, double_));
            this.end = double_;
        } else {
            this.end = double_;
            if (this.board.getCurrentShape() != null) {
                this.board.getCurrentShape().setCoordinates(PointsOperations.pointsToString(this.start, this.end));
            } else {
                this.board.setCurrentShape(new Rectangle(this.start, this.end, this.color, this.chat.getMyJID(), this.isFilled));
            }
            this.board.repaint();
        }
    }
}

