/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.ui;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.swing.ImageIcon;
import nu.fw.jeti.plugins.drawing.geometry.PointsOperations;
import nu.fw.jeti.plugins.drawing.shapes.PictureChat;
import nu.fw.jeti.plugins.drawing.shapes.Polygon;
import nu.fw.jeti.plugins.drawing.ui.Board;
import nu.fw.jeti.plugins.drawing.ui.Mode;

public class FilledPolylineMode
extends Mode {
    private Vector<Point2D.Double> points = new Vector();
    private boolean isFilled = true;

    public FilledPolylineMode(PictureChat pictureChat, Board board, String string, ImageIcon imageIcon, String string2, Integer n) {
        super(pictureChat, board, string, imageIcon, string2, n);
    }

    public void dispose() {
        super.dispose();
        this.points.clear();
    }

    public void mousePressed(Point2D.Double double_, Color color, int n, int n2) {
        this.color = color;
        this.points.add(double_);
        this.chat.unselect();
    }

    public void mouseReleased(Point2D.Double double_, int n, int n2) {
        Polygon polygon = new Polygon(this.points, this.color, this.chat.getMyJID(), this.isFilled);
        this.chat.draw(polygon);
        this.points.clear();
        this.board.setCurrentShape(null);
    }

    public void mouseDragged(Point2D.Double double_) {
        this.points.add(double_);
        if (this.board.getCurrentShape() != null) {
            this.board.getCurrentShape().setCoordinates(PointsOperations.pointsToString(this.points));
        } else {
            this.board.setCurrentShape(new Polygon(this.points, this.color, this.chat.getMyJID(), this.isFilled));
        }
        this.board.repaint();
    }
}

