/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import nu.fw.jeti.backend.roster.NormalJIDStatus;
import nu.fw.jeti.backend.roster.Roster;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.plugins.drawing.shapes.PictureChat;
import nu.fw.jeti.plugins.drawing.ui.UserRepresentation;
import nu.fw.jeti.plugins.drawing.ui.UsersSelectAction;
import nu.fw.jeti.util.I18N;

public class AddUsersDialog
extends JDialog {
    private Set<UserRepresentation> selectedUsers;
    private static final long serialVersionUID = -609695871275625226L;

    public AddUsersDialog(UsersSelectAction usersSelectAction, PictureChat pictureChat, Backend backend, String string, boolean bl) {
        this.setTitle(string);
        this.selectedUsers = new HashSet<UserRepresentation>();
        JScrollPane jScrollPane = this.createScrollPane(backend, pictureChat, bl);
        JButton jButton = this.createAddButton(usersSelectAction);
        JButton jButton2 = this.createCancelButton();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
        this.setModal(true);
        this.setLocationRelativeTo(null);
    }

    private JScrollPane createScrollPane(Backend backend, PictureChat pictureChat, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object;
        String[] stringArray = backend.getAllGroups();
        ArrayList<UserRepresentation> arrayList = new ArrayList<UserRepresentation>();
        Iterator iterator = Roster.getJIDStatussen();
        Object object2 = iterator;
        while (object2.hasNext()) {
            object = (NormalJIDStatus)object2.next();
            if (bl) {
                if (pictureChat.thereIsNoSuchUserYet(object.getJID())) continue;
                arrayList.add(new UserRepresentation((JIDStatus)object));
                continue;
            }
            if (!pictureChat.thereIsNoSuchUserYet(object.getJID())) continue;
            arrayList.add(new UserRepresentation((JIDStatus)object));
        }
        object = new DefaultMutableTreeNode(I18N.getText((String)"drawing", (String)"Groups"));
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        for (int i = 0; i < stringArray.length; ++i) {
            defaultMutableTreeNode = new DefaultMutableTreeNode(stringArray[i]);
            ((DefaultMutableTreeNode)object).add(defaultMutableTreeNode);
            vector.add(defaultMutableTreeNode);
        }
        Object object3 = vector.iterator();
        while (object3.hasNext()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)object3.next();
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                UserRepresentation userRepresentation = (UserRepresentation)iterator2.next();
                if (!userRepresentation.isInThisGroup(defaultMutableTreeNode.toString())) continue;
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(userRepresentation));
            }
        }
        if (bl) {
            object3 = new UserRepresentation(pictureChat.getMyJID());
            defaultMutableTreeNode = new DefaultMutableTreeNode(object3);
            ((DefaultMutableTreeNode)object).add(defaultMutableTreeNode);
        }
        object2 = new JTree((TreeNode)object);
        ((JTree)object2).setCellRenderer(new IconStatusRenderer());
        ((JTree)object2).getSelectionModel().setSelectionMode(4);
        ((JTree)object2).addTreeSelectionListener(new UsersSelectionListener((JTree)object2));
        object3 = new JScrollPane((Component)object2);
        ((JComponent)object3).setPreferredSize(new Dimension(180, 200));
        return object3;
    }

    private JButton createAddButton(UsersSelectAction usersSelectAction) {
        JButton jButton = new JButton(I18N.getText((String)"drawing", (String)"Add"));
        jButton.addActionListener(new AddUsersListener(usersSelectAction));
        return jButton;
    }

    private JButton createCancelButton() {
        JButton jButton = new JButton(I18N.getText((String)"drawing", (String)"Cancel"));
        jButton.addActionListener(new CancelListener());
        return jButton;
    }

    class UsersSelectionListener
    implements TreeSelectionListener {
        JTree tree;

        public UsersSelectionListener(JTree jTree) {
            this.tree = jTree;
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath[] treePathArray;
            TreePath[] treePathArray2 = treePathArray = treeSelectionEvent.getPaths();
            int n = treePathArray2.length;
            for (int i = 0; i < n; ++i) {
                TreePath treePath = treePathArray2[i];
                Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                if (treeSelectionEvent.isAddedPath(treePath)) {
                    if (!(object instanceof UserRepresentation)) continue;
                    AddUsersDialog.this.selectedUsers.add((UserRepresentation)object);
                    continue;
                }
                if (!(object instanceof UserRepresentation)) continue;
                AddUsersDialog.this.selectedUsers.remove((UserRepresentation)object);
            }
        }
    }

    class IconStatusRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -1848585234057535801L;

        IconStatusRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (bl3 && (defaultMutableTreeNode = (DefaultMutableTreeNode)object).getUserObject() instanceof UserRepresentation) {
                UserRepresentation userRepresentation = (UserRepresentation)defaultMutableTreeNode.getUserObject();
                this.setIcon(userRepresentation.getStatusIcon());
                this.setToolTipText(userRepresentation.getJIDAddress());
            }
            return this;
        }
    }

    class CancelListener
    implements ActionListener {
        CancelListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AddUsersDialog.this.dispose();
        }
    }

    class AddUsersListener
    implements ActionListener {
        UsersSelectAction action;

        public AddUsersListener(UsersSelectAction usersSelectAction) {
            this.action = usersSelectAction;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.action.obsluzSelectedUsers(AddUsersDialog.this.selectedUsers);
            AddUsersDialog.this.dispose();
        }
    }
}

