/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.shapes;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.plugins.drawing.geometry.PointsOperations;
import nu.fw.jeti.plugins.drawing.geometry.Vector;
import nu.fw.jeti.plugins.drawing.shapes.Shape;

public class Rectangle
extends Shape {
    public static final String NAME = "rectangle";
    private Point2D.Double upperLeft;
    private Point2D.Double bottomRight;

    public Rectangle(long l, JID jID, String string, Color color, int n, boolean bl) {
        super(l, jID, color, n);
        this.setCoordinates(string);
        this.isFilled = bl;
    }

    public Rectangle(Point2D.Double double_, Point2D.Double double_2, Color color, JID jID, boolean bl) {
        super(Rectangle.generateId(), jID, color, -1);
        this.upperLeft = PointsOperations.upperLeftPoint(double_, double_2);
        this.bottomRight = PointsOperations.bottomRightPoint(double_, double_2);
        this.isFilled = bl;
    }

    public void draw(Graphics graphics, int n, int n2) {
        Point point = this.ceil(this.upperLeft, n, n2);
        Point point2 = this.ceil(this.bottomRight, n, n2);
        if (this.isFilled) {
            graphics.setColor(this.color);
            graphics.fillRect(point.x + 1, point.y + 1, point2.x - point.x - 1, point2.y - point.y - 1);
        }
        if (this.isFilled) {
            graphics.setColor(this.borderColor);
        } else {
            graphics.setColor(this.color);
        }
        graphics.drawRect(point.x, point.y, point2.x - point.x, point2.y - point.y);
    }

    public void drawAsSelected(Graphics graphics, int n, int n2) {
        this.draw(graphics, n, n2);
        Point point = this.ceil(this.upperLeft, n, n2);
        Point point2 = this.ceil(this.bottomRight, n, n2);
        graphics.setColor(this.selectionColor);
        graphics.drawRect(point.x - 2, point.y - 2, 4, 4);
        graphics.drawRect(point2.x - 2, point.y - 2, 4, 4);
        graphics.drawRect(point2.x - 2, point2.y - 2, 4, 4);
        graphics.drawRect(point.x - 2, point2.y - 2, 4, 4);
    }

    public String getName() {
        return NAME;
    }

    public String getCoordinates() {
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        arrayList.add(this.upperLeft);
        arrayList.add(this.bottomRight);
        return PointsOperations.pointsToString(arrayList);
    }

    public void setCoordinates(String string) {
        List<Point2D.Double> list = PointsOperations.getPointsFromString(string);
        this.upperLeft = PointsOperations.upperLeftPoint(list.get(0), list.get(1));
        this.bottomRight = PointsOperations.bottomRightPoint(list.get(0), list.get(1));
    }

    public boolean isInsideTheRect(Point2D.Double double_, Point2D.Double double_2) {
        return PointsOperations.pointIsInsideRect(this.upperLeft, double_, double_2) && PointsOperations.pointIsInsideRect(this.bottomRight, double_, double_2);
    }

    public boolean isPointInShapesNeighbourhood(Point2D.Double double_, int n, int n2) {
        if (this.isFilled) {
            return this.isPointInShapesInterior(double_, n, n2);
        }
        return this.isPointInRectanglesNeighbourhood(double_, this.upperLeft, this.bottomRight, n, n2);
    }

    public Point2D.Double getDisplayPoint() {
        return PointsOperations.getMiddlePoint(this.upperLeft, new Point2D.Double(this.bottomRight.x, this.upperLeft.y));
    }

    public void changeCoordinates(Vector vector) {
        this.upperLeft = vector.addVectorToPoint(this.upperLeft);
        this.bottomRight = vector.addVectorToPoint(this.bottomRight);
    }

    public Point2D.Double getTheMostUpperLeftPoint() {
        return this.upperLeft;
    }

    public Point2D.Double getTheMostBottomRightPoint() {
        return this.bottomRight;
    }

    public boolean isPointInShapesInterior(Point2D.Double double_, int n, int n2) {
        Point point = this.ceil(this.upperLeft, n, n2);
        Point point2 = this.ceil(this.bottomRight, n, n2);
        Point2D.Double double_2 = this.ceilTo2DPointl(double_, n, n2);
        Point2D.Double double_3 = new Point2D.Double((double)point.x + 3.0, (double)point.y + 3.0);
        Point2D.Double double_4 = new Point2D.Double((double)point2.x + 3.0, (double)point2.y + 3.0);
        return PointsOperations.pointIsInsideRect(double_2, double_3, double_4);
    }
}

