/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.shapes;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.util.Vector;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.plugins.drawing.shapes.PolyPointsShape;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polyline
extends PolyPointsShape {
    public static final String NAME = "polyline";

    public Polyline(long l, JID jID, String string, Color color, int n) {
        super(l, jID, color, n);
        this.setCoordinates(string);
    }

    public Polyline(long l, JID jID, double[] dArray, double[] dArray2, Color color) {
        super(l, jID, color, -1);
        this.pointsX = dArray;
        this.pointsY = dArray2;
    }

    public Polyline(Vector<Point2D.Double> vector, Color color, JID jID) {
        super(Polyline.generateId(), jID, color, -1);
        if (this.pointsX == null || this.pointsY == null) {
            this.pointsX = new double[vector.size()];
            this.pointsY = new double[vector.size()];
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.pointsX[i] = vector.get((int)i).x;
            this.pointsY[i] = vector.get((int)i).y;
        }
    }

    @Override
    public void draw(Graphics graphics, int n, int n2) {
        this.ceilPoints(n, n2);
        graphics.setColor(this.color);
        graphics.drawPolyline(this.scaledPointsX, this.scaledPointsY, this.scaledPointsX.length);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void drawAsSelected(Graphics graphics, int n, int n2) {
        this.draw(graphics, n, n2);
        graphics.setColor(this.selectionColor);
        graphics.drawRect(this.scaledPointsX[0] - 2, this.scaledPointsY[0] - 2, 4, 4);
        int n3 = this.scaledPointsX[0];
        int n4 = this.scaledPointsY[0];
        for (int i = 0; i < this.scaledPointsX.length - 1; ++i) {
            if (Math.abs(this.scaledPointsX[i] - n3) <= 10 && Math.abs(this.scaledPointsY[i] - n4) <= 10) continue;
            n3 = this.scaledPointsX[i];
            n4 = this.scaledPointsY[i];
            graphics.drawRect(n3 - 2, n4 - 2, 4, 4);
        }
        graphics.drawRect(this.scaledPointsX[this.scaledPointsX.length - 1] - 2, this.scaledPointsY[this.scaledPointsY.length - 1] - 2, 4, 4);
    }

    @Override
    public boolean isPointInShapesNeighbourhood(Point2D.Double double_, int n, int n2) {
        return this.isPointInPolylinesNeighbourhood(this.pointsX, this.pointsY, double_, n, n2);
    }

    @Override
    public boolean isPointInShapesInterior(Point2D.Double double_, int n, int n2) {
        return false;
    }
}

