/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.shapes;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Vector;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.plugins.drawing.shapes.PolyPointsShape;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polygon
extends PolyPointsShape {
    public static final String NAME = "polygon";

    public Polygon(long l, JID jID, String string, Color color, int n, boolean bl) {
        super(l, jID, color, n);
        this.setCoordinates(string);
        this.isFilled = bl;
    }

    public Polygon(Vector<Point2D.Double> vector, Color color, JID jID, boolean bl) {
        super(Polygon.generateId(), jID, color, -1);
        if (this.pointsX == null || this.pointsY == null) {
            this.pointsX = new double[vector.size()];
            this.pointsY = new double[vector.size()];
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.pointsX[i] = vector.get((int)i).x;
            this.pointsY[i] = vector.get((int)i).y;
        }
        this.isFilled = bl;
    }

    @Override
    public void draw(Graphics graphics, int n, int n2) {
        this.ceilPoints(n, n2);
        if (this.isFilled) {
            graphics.setColor(this.color);
            graphics.fillPolygon(this.scaledPointsX, this.scaledPointsY, this.scaledPointsX.length);
        }
        if (this.isFilled) {
            graphics.setColor(this.borderColor);
        } else {
            graphics.setColor(this.color);
        }
        graphics.drawPolygon(this.scaledPointsX, this.scaledPointsY, this.scaledPointsX.length);
    }

    @Override
    public void drawAsSelected(Graphics graphics, int n, int n2) {
        this.draw(graphics, n, n2);
        graphics.setColor(this.selectionColor);
        for (int i = 0; i < this.scaledPointsX.length; ++i) {
            graphics.drawRect(this.scaledPointsX[i] - 2, this.scaledPointsY[i] - 2, 4, 4);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isPointInShapesNeighbourhood(Point2D.Double double_, int n, int n2) {
        if (this.isFilled) {
            return this.isPointInShapesInterior(double_, n, n2);
        }
        return this.isPointInPolylinesNeighbourhood(this.pointsX, this.pointsY, double_, n, n2);
    }

    @Override
    public boolean isPointInShapesInterior(Point2D.Double double_, int n, int n2) {
        int n3 = 1000;
        this.ceilPoints(n3, n3);
        Point point = this.ceil(double_, n3, n3);
        java.awt.Polygon polygon = new java.awt.Polygon(this.scaledPointsX, this.scaledPointsY, this.scaledPointsX.length);
        return polygon.contains(point);
    }
}

