/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.shapes;

import java.awt.Color;
import java.awt.geom.Point2D;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.plugins.drawing.geometry.PointsOperations;
import nu.fw.jeti.plugins.drawing.geometry.Vector;
import nu.fw.jeti.plugins.drawing.shapes.Shape;

public abstract class PolyPointsShape
extends Shape {
    protected double[] pointsX;
    protected double[] pointsY;
    protected int[] scaledPointsX;
    protected int[] scaledPointsY;

    public PolyPointsShape(long l, JID jID, Color color, int n) {
        super(l, jID, color, n);
    }

    public String getCoordinates() {
        return PointsOperations.pointsToString(this.pointsX, this.pointsY);
    }

    public void setCoordinates(String string) {
        String[] stringArray = string.split("\\s");
        this.pointsX = new double[stringArray.length / 2];
        this.pointsY = new double[stringArray.length / 2];
        for (int i = 0; i < stringArray.length / 2; ++i) {
            this.pointsX[i] = Double.parseDouble(stringArray[2 * i]);
            this.pointsY[i] = Double.parseDouble(stringArray[2 * i + 1]);
        }
    }

    public boolean isInsideTheRect(Point2D.Double double_, Point2D.Double double_2) {
        return this.isPolylineInsideRect(this.pointsX, this.pointsY, double_, double_2);
    }

    public Point2D.Double getDisplayPoint() {
        return this.getDisplayPointForPolyline(this.pointsX, this.pointsY);
    }

    public Point2D.Double getTheMostUpperLeftPoint() {
        return this.getTheMostUpperLeftPoint(this.pointsX, this.pointsY);
    }

    public Point2D.Double getTheMostBottomRightPoint() {
        return this.getTheMostBottomRightPoint(this.pointsX, this.pointsY);
    }

    public void changeCoordinates(Vector vector) {
        for (int i = 0; i < this.pointsX.length; ++i) {
            Point2D.Double double_ = vector.addVectorToPoint(new Point2D.Double(this.pointsX[i], this.pointsY[i]));
            this.pointsX[i] = double_.x;
            this.pointsY[i] = double_.y;
        }
    }

    protected void ceilPoints(int n, int n2) {
        this.scaledPointsX = new int[this.pointsX.length];
        this.scaledPointsY = new int[this.pointsY.length];
        for (int i = 0; i < this.pointsX.length; ++i) {
            this.scaledPointsX[i] = this.ceil(this.pointsX[i], n);
            this.scaledPointsY[i] = this.ceil(this.pointsY[i], n2);
        }
    }

    protected boolean isPolylineInsideRect(double[] dArray, double[] dArray2, Point2D.Double double_, Point2D.Double double_2) {
        for (int i = 0; i < dArray.length; ++i) {
            if (PointsOperations.pointIsInsideRect(new Point2D.Double(dArray[i], dArray2[i]), double_, double_2)) continue;
            return false;
        }
        return true;
    }

    protected boolean isPointInPolylinesNeighbourhood(double[] dArray, double[] dArray2, Point2D.Double double_, int n, int n2) {
        for (int i = 0; i < dArray.length - 1; ++i) {
            if (!this.isPointInLinesNeighbourhood(new Point2D.Double(dArray[i], dArray2[i]), new Point2D.Double(dArray[i + 1], dArray2[i + 1]), double_, n, n2)) continue;
            return true;
        }
        if (dArray.length - 2 >= 0) {
            return this.isPointInLinesNeighbourhood(new Point2D.Double(dArray[dArray.length - 2], dArray2[dArray.length - 2]), new Point2D.Double(dArray[dArray.length - 1], dArray2[dArray.length - 1]), double_, n, n2);
        }
        return false;
    }

    protected Point2D.Double getDisplayPointForPolyline(double[] dArray, double[] dArray2) {
        if (dArray.length == 1) {
            return new Point2D.Double(dArray[0], dArray2[0]);
        }
        int n = dArray.length / 2;
        return PointsOperations.getMiddlePoint(new Point2D.Double(dArray[n - 1], dArray2[n - 1]), new Point2D.Double(dArray[n], dArray2[n]));
    }
}

