/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.shapes;

import java.awt.Color;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Message;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.elements.XExtension;
import nu.fw.jeti.plugins.drawing.Plugin;
import nu.fw.jeti.plugins.drawing.elements.BackgroundSettingMessage;
import nu.fw.jeti.plugins.drawing.elements.ColorSettingMessage;
import nu.fw.jeti.plugins.drawing.elements.CreationMessage;
import nu.fw.jeti.plugins.drawing.elements.DeletionMessage;
import nu.fw.jeti.plugins.drawing.elements.DisplayMessage;
import nu.fw.jeti.plugins.drawing.elements.PictureMessage;
import nu.fw.jeti.plugins.drawing.elements.TranslationMessage;
import nu.fw.jeti.plugins.drawing.geometry.Vector;
import nu.fw.jeti.plugins.drawing.shapes.PicturesContent;
import nu.fw.jeti.plugins.drawing.shapes.Shape;
import nu.fw.jeti.plugins.drawing.shapes.UndoRedoStackRepresentation;
import nu.fw.jeti.plugins.drawing.shapes.actions.Action;
import nu.fw.jeti.plugins.drawing.shapes.actions.ActionPriorityStack;
import nu.fw.jeti.plugins.drawing.shapes.actions.BackgroundColorSetting;
import nu.fw.jeti.plugins.drawing.shapes.actions.ColorSetting;
import nu.fw.jeti.plugins.drawing.shapes.actions.Creation;
import nu.fw.jeti.plugins.drawing.shapes.actions.CurrentUsersDelivery;
import nu.fw.jeti.plugins.drawing.shapes.actions.Deletion;
import nu.fw.jeti.plugins.drawing.shapes.actions.Display;
import nu.fw.jeti.plugins.drawing.shapes.actions.Pasting;
import nu.fw.jeti.plugins.drawing.shapes.actions.Translation;
import nu.fw.jeti.plugins.drawing.ui.HistoryPanel;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PictureHistory {
    private Map<Long, Shape> allShapes;
    private UndoRedoStackRepresentation myActions;
    private ActionPriorityStack historyStack;
    private Backend backend;
    private HistoryPanel historyPanel;
    private int counter;
    private static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(3, 0);

    public PictureHistory(Backend backend, HistoryPanel historyPanel) {
        this.backend = backend;
        this.historyPanel = historyPanel;
        this.allShapes = Collections.synchronizedMap(new HashMap());
        this.myActions = new UndoRedoStackRepresentation();
        this.historyStack = new ActionPriorityStack();
        this.counter = 0;
    }

    public void addIncomingMessage(PictureMessage pictureMessage, List<PicturesContent> list) {
        Action action = null;
        if (pictureMessage instanceof CreationMessage) {
            Shape shape = this.createShapeFromCreationMessage((CreationMessage)pictureMessage);
            action = new Creation(shape, this.allShapes, pictureMessage.getTime(), pictureMessage.getActionsAuthor(), pictureMessage.getCounter());
        } else if (pictureMessage instanceof DisplayMessage) {
            action = new Display(pictureMessage.getShapeIdList(), this.allShapes, pictureMessage.getTime(), pictureMessage.getActionsAuthor(), pictureMessage.getCounter());
        } else if (pictureMessage instanceof DeletionMessage) {
            action = new Deletion(pictureMessage.getShapeIdList(), this.allShapes, pictureMessage.getTime(), pictureMessage.getActionsAuthor(), pictureMessage.getCounter());
        } else if (pictureMessage instanceof TranslationMessage) {
            action = new Translation(pictureMessage.getShapeIdList(), this.allShapes, ((TranslationMessage)pictureMessage).getVector(), pictureMessage.getTime(), pictureMessage.getActionsAuthor(), pictureMessage.getCounter());
        } else if (pictureMessage instanceof ColorSettingMessage) {
            action = new ColorSetting(pictureMessage.getShapeIdList(), this.allShapes, ((ColorSettingMessage)pictureMessage).getColor(), pictureMessage.getTime(), pictureMessage.getActionsAuthor(), pictureMessage.getCounter());
        } else if (pictureMessage instanceof BackgroundSettingMessage) {
            action = new BackgroundColorSetting(((BackgroundSettingMessage)pictureMessage).getOldColor(), ((BackgroundSettingMessage)pictureMessage).getColor(), pictureMessage.getTime(), pictureMessage.getActionsAuthor(), pictureMessage.getCounter());
        }
        if (action != null) {
            this.historyStack.add(action, list);
            this.addActionToHistoryPanel(action);
            for (PicturesContent picturesContent : list) {
                action.execute(picturesContent);
            }
        } else {
            throw new IllegalArgumentException(new StringBuffer().append("PictureHistory: The message ").append((Object)pictureMessage).append(" service is not implemented yet.").toString());
        }
        this.increaseCounter(pictureMessage);
    }

    private void addActionToHistoryPanel(Action action) {
        this.historyPanel.addAction(action);
    }

    private void increaseCounter(PictureMessage pictureMessage) {
        this.counter = Math.max(this.counter, pictureMessage.getCounter() + 1);
    }

    private void increaseCounter(int n) {
        this.counter += n;
    }

    public void addShapeDrawnByMe(Shape shape, String string, List<PicturesContent> list, List<JID> list2, String string2) {
        if (shape == null) {
            return;
        }
        shape.setDisplayHeight(this.counter);
        String string3 = this.generateTime();
        Creation creation = new Creation(shape, this.allShapes, string3, string, this.counter);
        this.historyStack.add((Action)creation, list);
        this.sendMyAction(list2, string2, creation);
        this.executeMyAction(list, creation);
        this.addActionToHistoryPanel(creation);
        List<Long> list3 = Action.createShapeIdList(shape.getShapeId());
        Display display = new Display(list3, this.allShapes, string3, string, this.counter);
        this.serviceMyAction(list, list2, string2, display);
    }

    private String generateTime() {
        return DATE_FORMAT.format(new Date());
    }

    public void addDeletionDoneByMe(List<Long> list, String string, List<PicturesContent> list2, List<JID> list3, String string2) {
        if (list.isEmpty()) {
            return;
        }
        Deletion deletion = new Deletion(list, this.allShapes, this.generateTime(), string, this.counter);
        this.serviceMyAction(list2, list3, string2, deletion);
    }

    public void addTranslationDoneByMe(List<Long> list, Vector vector, String string, List<PicturesContent> list2, List<JID> list3, String string2) {
        if (list.isEmpty()) {
            return;
        }
        Translation translation = new Translation(list, this.allShapes, vector, this.generateTime(), string, this.counter);
        this.serviceMyAction(list2, list3, string2, translation);
    }

    public void sendCurrentUsers(String string, List<JID> list, List<JID> list2, String string2) {
        CurrentUsersDelivery currentUsersDelivery = new CurrentUsersDelivery(list, this.generateTime(), string, this.counter);
        this.sendMyAction(list2, string2, currentUsersDelivery);
    }

    private void serviceMyAction(List<PicturesContent> list, List<JID> list2, String string, Action action) {
        this.historyStack.add(action, list);
        this.sendMyAction(list2, string, action);
        this.executeMyAction(list, action);
        this.myActions.addAction(action);
        this.addActionToHistoryPanel(action);
    }

    private void executeMyAction(List<PicturesContent> list, Action action) {
        for (PicturesContent picturesContent : list) {
            action.execute(picturesContent);
        }
    }

    private void sendMyAction(List<JID> list, String string, Action action) {
        List<PictureMessage> list2 = action.getPictureMessageList(list, string);
        for (PictureMessage pictureMessage : list2) {
            this.backend.send((Packet)new Message(null, pictureMessage.getTo(), (XExtension)pictureMessage));
        }
        this.increaseCounter(1);
        if (action instanceof ColorSetting) {
            this.increaseCounter(action.getShapesNumber());
        }
    }

    public void undoMyAction(List<PicturesContent> list, List<JID> list2, String string) {
        Action action = this.myActions.undo();
        if (action != null) {
            Action action2 = action.giveComplementaryAction(this.generateTime(), this.counter);
            this.historyStack.add(action2, list);
            this.sendMyAction(list2, string, action2);
            this.executeMyAction(list, action2);
            this.addActionToHistoryPanel(action2);
        }
        this.unselect(list);
    }

    public void redoMyAction(List<PicturesContent> list, List<JID> list2, String string) {
        Action action = this.myActions.redo();
        if (action != null) {
            action.setCounter(this.counter);
            this.historyStack.add(action, list);
            this.sendMyAction(list2, string, action);
            this.executeMyAction(list, action);
            this.addActionToHistoryPanel(action);
        }
        this.unselect(list);
    }

    private void unselect(List<PicturesContent> list) {
        for (PicturesContent picturesContent : list) {
            picturesContent.unselect();
        }
    }

    private Shape createShapeFromCreationMessage(CreationMessage creationMessage) {
        long l = creationMessage.getShapeIdList().get(0);
        Shape shape = Plugin.createShape(creationMessage.getShapeName(), l, creationMessage.getAuthor(), creationMessage.getCoordinates(), creationMessage.getColor(), creationMessage.getShapeHeight(), creationMessage.isFilled());
        return shape;
    }

    public void sendAllHistory(List<JID> list, String string) {
        for (int i = 0; i < this.historyStack.size(); ++i) {
            Action action = this.historyStack.elementAt(i);
            this.sendMyAction(list, string, action);
        }
    }

    public void addBackgroundColorSetting(String string, Color color, Color color2, List<PicturesContent> list, List<JID> list2, String string2) {
        BackgroundColorSetting backgroundColorSetting = new BackgroundColorSetting(color, color2, this.generateTime(), string, this.counter);
        this.serviceMyAction(list, list2, string2, backgroundColorSetting);
    }

    public void addColorSetting(List<Long> list, String string, Color color, List<PicturesContent> list2, List<JID> list3, String string2) {
        if (list.isEmpty()) {
            return;
        }
        ColorSetting colorSetting = new ColorSetting(list, this.allShapes, color, this.generateTime(), string, this.counter);
        this.serviceMyAction(list2, list3, string2, colorSetting);
    }

    public void addPasteDoneByMe(List<Shape> list, Vector vector, String string, List<PicturesContent> list2, List<JID> list3, String string2) {
        Pasting pasting = new Pasting(list, this.allShapes, vector, this.generateTime(), string, this.counter);
        this.increaseCounter(list.size());
        this.serviceMyAction(list2, list3, string2, pasting);
    }
}

