/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.shapes;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.plugins.drawing.geometry.PointsOperations;
import nu.fw.jeti.plugins.drawing.geometry.Vector;
import nu.fw.jeti.plugins.drawing.shapes.Shape;

public class Ellipse
extends Shape {
    private double x;
    private double y;
    private double width;
    private double height;
    public static final String NAME = "ellipse";

    public Ellipse(long l, JID jID, String string, Color color, int n, boolean bl) {
        super(l, jID, color, n);
        this.setCoordinates(string);
        this.isFilled = bl;
    }

    public Ellipse(double d, double d2, double d3, double d4, Color color, JID jID, boolean bl) {
        super(Ellipse.generateId(), jID, color, -1);
        this.isFilled = bl;
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
    }

    public void draw(Graphics graphics, int n, int n2) {
        int n3 = this.ceil(this.x, n);
        int n4 = this.ceil(this.y, n2);
        int n5 = this.ceil(this.width, n);
        int n6 = this.ceil(this.height, n2);
        if (this.isFilled) {
            graphics.setColor(this.color);
            graphics.fillOval(n3, n4, n5 + 1, n6 + 1);
        }
        if (this.isFilled) {
            graphics.setColor(this.borderColor);
        } else {
            graphics.setColor(this.color);
        }
        graphics.drawOval(n3, n4, n5, n6);
    }

    public void drawAsSelected(Graphics graphics, int n, int n2) {
        this.draw(graphics, n, n2);
        int n3 = this.ceil(this.x, n);
        int n4 = this.ceil(this.y, n2);
        int n5 = this.ceil(this.width, n);
        int n6 = this.ceil(this.height, n2);
        graphics.setColor(this.selectionColor);
        graphics.drawRect(n3 - 2, n4 - 2, 4, 4);
        graphics.drawRect(n3 - 2, n4 + n6 - 2, 4, 4);
        graphics.drawRect(n3 + n5 - 2, n4 - 2, 4, 4);
        graphics.drawRect(n3 + n5 - 2, n4 + n6 - 2, 4, 4);
    }

    public String getName() {
        return NAME;
    }

    public String getCoordinates() {
        return this.x + " " + this.y + " " + this.width + " " + this.height;
    }

    public void setCoordinates(String string) {
        String[] stringArray = string.split("\\s");
        int n = 0;
        this.x = Double.parseDouble(stringArray[n++]);
        this.y = Double.parseDouble(stringArray[n++]);
        this.width = Double.parseDouble(stringArray[n++]);
        this.height = Double.parseDouble(stringArray[n++]);
    }

    public void changeCoordinates(Vector vector) {
        Point2D.Double double_ = vector.addVectorToPoint(new Point2D.Double(this.x, this.y));
        this.x = double_.x;
        this.y = double_.y;
    }

    public boolean isInsideTheRect(Point2D.Double double_, Point2D.Double double_2) {
        return PointsOperations.pointIsInsideRect(new Point2D.Double(this.x, this.y), double_, double_2) && PointsOperations.pointIsInsideRect(new Point2D.Double(this.x + this.width, this.y + this.height), double_, double_2);
    }

    public boolean isPointInShapesNeighbourhood(Point2D.Double double_, int n, int n2) {
        double d;
        double d2;
        if (this.isFilled) {
            return this.isPointInShapesInterior(double_, n, n2);
        }
        int n3 = this.ceil(this.width / 2.0, n);
        int n4 = this.ceil(this.height / 2.0, n2);
        int n5 = this.ceil(this.x, n);
        int n6 = this.ceil(this.y, n2);
        Point point = this.ceil(double_, n, n2);
        int n7 = point.x - (n5 + n3);
        int n8 = point.y - (n6 + n4);
        if (((double)n3 > 3.0 || (double)n4 > 3.0) && (d2 = (double)n7 / ((double)n3 - 3.0)) * d2 + (d = (double)n8 / ((double)n4 - 3.0)) * d < 1.0) {
            return false;
        }
        d2 = (double)n7 / ((double)n3 + 3.0);
        d = (double)n8 / ((double)n4 + 3.0);
        return d2 * d2 + d * d <= 1.0;
    }

    public Point2D.Double getDisplayPoint() {
        return new Point2D.Double(this.x + this.width / 2.0, this.y + this.height / 2.0);
    }

    public Point2D.Double getTheMostUpperLeftPoint() {
        return new Point2D.Double(this.x, this.y);
    }

    public Point2D.Double getTheMostBottomRightPoint() {
        return new Point2D.Double(this.x + this.width, this.y + this.height);
    }

    public boolean isPointInShapesInterior(Point2D.Double double_, int n, int n2) {
        int n3 = this.ceil(this.x, n);
        int n4 = this.ceil(this.y, n2);
        int n5 = this.ceil(this.width, n);
        int n6 = this.ceil(this.height, n2);
        Point2D.Double double_2 = this.ceilTo2DPointl(double_, n, n2);
        Point2D.Double double_3 = new Point2D.Double((double)n3 - 3.0, (double)n4 - 3.0);
        Point2D.Double double_4 = new Point2D.Double((double)(n3 + n5) - 3.0, (double)(n4 + n6) - 3.0);
        return PointsOperations.pointIsInsideRect(double_2, double_3, double_4);
    }
}

