/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.filetransfer.socks5;

import java.util.Iterator;
import java.util.List;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.plugins.filetransfer.GetFileWindow;
import nu.fw.jeti.plugins.filetransfer.Plugin;
import nu.fw.jeti.plugins.filetransfer.socks5.ReceiveSocks5;
import nu.fw.jeti.plugins.filetransfer.socks5.StreamHost;
import nu.fw.jeti.util.Log;

public class Socks5Extension
extends Extension
implements IQExtension {
    private String sid;
    private JID streamHost;
    private List streamHosts;
    private JID activate;

    public Socks5Extension(String sid, JID streamHost, List streamHosts, JID activate) {
        this.sid = sid;
        this.streamHost = streamHost;
        this.streamHosts = streamHosts;
        this.activate = activate;
    }

    public Socks5Extension(String sid, List streamhosts) {
        this.sid = sid;
        this.streamHosts = streamhosts;
    }

    public Socks5Extension(String sid, JID activation) {
        this.sid = sid;
        this.activate = activation;
    }

    public Socks5Extension(JID streamHost, String sid) {
        this.sid = sid;
        this.streamHost = streamHost;
    }

    public String getSid() {
        return this.sid;
    }

    public JID getStreamHostUsed() {
        return this.streamHost;
    }

    public boolean hasStreamHosts() {
        return this.streamHosts != null;
    }

    public Iterator getStreamHosts() {
        return this.streamHosts.iterator();
    }

    public void execute(InfoQuery iq, Backend backend) {
        if (iq.getType().equals("set")) {
            GetFileWindow w = Plugin.getGetFile(iq.getFrom(), this.sid);
            if (w == null) {
                Log.xmlReceivedError((String)"Socks stream from unknown");
            } else {
                w.startDownloading(new ReceiveSocks5(backend, iq, w));
            }
        }
    }

    public void appendToXML(StringBuffer xml) {
        xml.append("<query xmlns= 'http://jabber.org/protocol/bytestreams'");
        Socks5Extension.appendAttribute((StringBuffer)xml, (String)"sid", (String)this.sid);
        xml.append(">");
        Socks5Extension.appendElement((StringBuffer)xml, (String)"activate", (Object)this.activate);
        if (this.streamHost != null) {
            xml.append("<streamhost-used");
            Socks5Extension.appendAttribute((StringBuffer)xml, (String)"jid", (Object)this.streamHost);
            xml.append("/>");
        }
        if (this.streamHosts != null) {
            Iterator i = this.streamHosts.iterator();
            while (i.hasNext()) {
                ((StreamHost)((Object)i.next())).appendToXML(xml);
            }
        }
        xml.append("</query>");
    }
}

