/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.filetransfer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import nu.fw.jeti.backend.roster.Roster;
import nu.fw.jeti.events.IQResultListener;
import nu.fw.jeti.events.JETIListener;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.XData;
import nu.fw.jeti.jabber.elements.XDataBuilder;
import nu.fw.jeti.jabber.elements.XDataField;
import nu.fw.jeti.jabber.elements.XDataFieldBuilder;
import nu.fw.jeti.plugins.filetransfer.IQSi;
import nu.fw.jeti.plugins.filetransfer.Plugin;
import nu.fw.jeti.plugins.filetransfer.StreamSend;
import nu.fw.jeti.plugins.filetransfer.XSiFileTransfer;
import nu.fw.jeti.plugins.filetransfer.ibb.IBBSend;
import nu.fw.jeti.plugins.filetransfer.socks5.Socks5Send;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;
import nu.fw.jeti.util.Preferences;

public class SendFileProgress
extends JFrame
implements IQResultListener {
    private Backend backend;
    private JID to;
    private StreamSend streamSend;
    private Timer timer;
    private String id;
    private File file;
    private boolean begun = false;
    private JButton btnAbort = new JButton();
    private JLabel toTxt = new JLabel();
    private JLabel fileTxt = new JLabel();
    private JLabel sizeTxt = new JLabel();
    private JLabel statusTxt = new JLabel();
    private JProgressBar progressBar = new JProgressBar();
    static /* synthetic */ Class class$0;

    public SendFileProgress(Backend backend, JID to, File file, String description) {
        this.backend = backend;
        this.to = to;
        this.file = file;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JIDStatus js = Roster.getJIDStatus((JID)to);
        if (js != null) {
            this.toTxt.setText(js.getNick());
        } else {
            this.toTxt.setText(to.toString());
        }
        this.fileTxt.setText(file.toString());
        this.sizeTxt.setText(Plugin.getSizeText(file.length()));
        this.statusTxt.setText(String.valueOf(I18N.gettext((String)"filetransfer.Opening_connection")) + "...");
        this.pack();
        this.setLocationRelativeTo(null);
        this.progressBar.setMaximum((int)(file.length() / 1024L));
        this.id = "file" + backend.getIdentifier();
        XDataBuilder xdb = new XDataBuilder();
        xdb.type = "form";
        XDataFieldBuilder xdfb = new XDataFieldBuilder();
        xdfb.var = "stream-method";
        xdfb.type = "list-single";
        if (Preferences.getBoolean((String)"filetransfer", (String)"bytestreams.enable", (boolean)true)) {
            xdfb.addOption("http://jabber.org/protocol/bytestreams");
        }
        if (Preferences.getBoolean((String)"filetransfer", (String)"ibb.enable", (boolean)true)) {
            xdfb.addOption("http://jabber.org/protocol/ibb");
        }
        xdb.addField(xdfb.build());
        XData xdata = null;
        try {
            xdata = xdb.build();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        IQSi si = new IQSi(this.id, "http://jabber.org/protocol/si/profile/file-transfer", null, xdata, new XSiFileTransfer(file.getName(), null, null, file.length(), description, 0, 0L));
        backend.send(new InfoQuery(to, "set", "filetransfer" + backend.getIdentifier(), (IQExtension)si), (IQResultListener)this, 0);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("nu.fw.jeti.events.ErrorListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        backend.addListener((Class)clazz, (JETIListener)this);
    }

    private void jbInit() throws Exception {
        this.setIconImage(StatusIcons.getImageIcon((String)"jeti").getImage());
        this.setTitle(I18N.gettext((String)"filetransfer.File_Transfer"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.anchor = 21;
        c.fill = 1;
        c.insets = new Insets(3, 5, 0, 3);
        GridBagConstraints c2 = (GridBagConstraints)c.clone();
        c2.gridwidth = 0;
        c2.weightx = 1.0;
        JLabel lbl = new JLabel(I18N.gettext((String)"filetransfer.To"));
        this.getContentPane().add((Component)lbl, c);
        this.getContentPane().add((Component)this.toTxt, c2);
        lbl = new JLabel(I18N.gettext((String)"filetransfer.File_Name"));
        this.getContentPane().add((Component)lbl, c);
        this.getContentPane().add((Component)this.fileTxt, c2);
        lbl = new JLabel(I18N.gettext((String)"filetransfer.File_Size"));
        this.getContentPane().add((Component)lbl, c);
        this.getContentPane().add((Component)this.sizeTxt, c2);
        c.gridwidth = 0;
        c.insets = new Insets(5, 5, 0, 5);
        c.anchor = 10;
        c.weightx = 1.0;
        c.fill = 0;
        this.getContentPane().add((Component)this.statusTxt, c);
        this.progressBar.setPreferredSize(new Dimension(300, 17));
        c.fill = 1;
        c.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.progressBar, c);
        this.getRootPane().setDefaultButton(this.btnAbort);
        c.fill = 0;
        c.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.btnAbort, c);
        AbstractAction abortAction = new AbstractAction(I18N.gettext((String)"filetransfer.Abort")){

            public void actionPerformed(ActionEvent e) {
                SendFileProgress.this.btnAbort_actionPerformed(e);
            }
        };
        this.btnAbort.setAction(abortAction);
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JLayeredPane layeredPane = this.getLayeredPane();
        layeredPane.getActionMap().put("cancel", abortAction);
        layeredPane.getInputMap(2).put(stroke, "abort");
    }

    void btnAbort_actionPerformed(ActionEvent e) {
        if (this.streamSend != null) {
            this.timer.stop();
            this.streamSend.cancel();
        }
        this.dispose();
    }

    public void iqResult(InfoQuery query) {
        if (query.getType().equals("result")) {
            IQSi iqSi = (IQSi)query.getIQExtension();
            XSiFileTransfer sifi = iqSi.getSiprofile();
            String streamMethod = null;
            XData data = iqSi.getXDataForm();
            if (data.hasFields()) {
                Iterator i = data.getFields();
                while (i.hasNext()) {
                    XDataField datafield = (XDataField)i.next();
                    if (!"stream-method".equals(datafield.getVar())) continue;
                    streamMethod = datafield.getValue();
                }
            }
            if ("http://jabber.org/protocol/ibb".equals(streamMethod)) {
                this.streamSend = new IBBSend(this.file, this.backend, this, this.to, this.id);
            } else if ("http://jabber.org/protocol/bytestreams".equals(streamMethod)) {
                this.streamSend = new Socks5Send(this.file, this.backend, this, this.to, this.id);
            } else {
                Popups.messagePopup((String)I18N.gettext((String)"filetransfer.Problem_during_file_transfer,_transfer_aborted"), (String)I18N.gettext((String)"filetransfer.File_Transfer"));
                this.dispose();
                return;
            }
            this.initTimer();
        } else if (query.getType().equals("error")) {
            String msg = query.getErrorCode() == 403 ? MessageFormat.format(I18N.gettext((String)"filetransfer.{0}_did_not_accept_the_file"), Roster.getJIDStatus((JID)this.to).getNick()) : (query.getErrorCode() == 404 ? MessageFormat.format(I18N.gettext((String)"filetransfer.{0}_is_not_online"), Roster.getJIDStatus((JID)this.to).getNick()) : (query.getErrorCode() == 400 ? I18N.gettext((String)"filetransfer.No_compatible_transfer_protocols_found") : (query.getErrorCode() == 501 ? MessageFormat.format(I18N.gettext((String)"filetransfer.{0}_does_not_support_file_transfer_or_is_offline"), Roster.getJIDStatus((JID)this.to).getNick()) : I18N.gettext((String)"filetransfer.Problem_during_file_transfer,_transfer_aborted"))));
            Popups.messagePopup((String)msg, (String)this.file.getName());
            this.dispose();
        }
    }

    private void updateProgress() {
        int bytes = 0;
        bytes = (int)this.streamSend.getBytes() / 1024;
        if (bytes > 0 && !this.begun) {
            this.statusTxt.setText(String.valueOf(I18N.gettext((String)"filetransfer.Transferring")) + "...");
            this.begun = true;
        }
        this.progressBar.setValue(bytes);
    }

    private void initTimer() {
        this.timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SendFileProgress.this.updateProgress();
            }
        });
        this.timer.start();
    }

    public void stop() {
        this.timer.stop();
        this.dispose();
    }

    public void done() {
        this.timer.stop();
        this.updateProgress();
        this.streamSend = null;
        if (Preferences.getBoolean((String)"filetransfer", (String)"closeOnComplete", (boolean)false)) {
            this.dispose();
        } else {
            this.statusTxt.setText(I18N.gettext((String)"filetransfer.Transfer_complete"));
            this.btnAbort.setText(I18N.gettext((String)"filetransfer.Close"));
            this.progressBar.setValue(this.progressBar.getMaximum());
        }
    }
}

