/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.filetransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import nu.fw.jeti.backend.roster.JIDStatusGroup;
import nu.fw.jeti.backend.roster.PrimaryJIDStatus;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.XData;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.RosterMenuListener;
import nu.fw.jeti.plugins.filetransfer.GetFileWindow;
import nu.fw.jeti.plugins.filetransfer.IQSiHandler;
import nu.fw.jeti.plugins.filetransfer.SendFileWindow;
import nu.fw.jeti.plugins.filetransfer.XSiFileTransferHandler;
import nu.fw.jeti.plugins.filetransfer.ibb.IBBHandler;
import nu.fw.jeti.plugins.filetransfer.socks5.Socks5Handler;
import nu.fw.jeti.plugins.filetransfer.socks5.Socks5Send;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;
import nu.fw.jeti.util.Utils;
import org.xml.sax.Attributes;

public class Plugin
implements Plugins {
    private static Backend backend;
    private static Plugin plugin;
    private static JFileChooser fileChooser;
    private Map fileWindows = new HashMap(10);
    public static final String VERSION = "0.1";
    public static final String DESCRIPTION = "filetransfer.File_Transfer";
    public static final String MIN_JETI_VERSION = "0.6.1";
    public static final String NAME = "filetransfer";
    public static final String ABOUT = "by E.S. de Boer";

    static {
        fileChooser = new JFileChooser();
    }

    public static void init(final Backend backend) {
        backend.getMain().addToOnlineRosterMenu(String.valueOf(I18N.gettext((String)"filetransfer.Transfer_File")) + "...", new RosterMenuListener(){

            public void actionPerformed(JIDStatus jidStatus, JIDStatusGroup group) {
                new SendFileWindow(backend, jidStatus.getCompleteJID()).setVisible(true);
            }
        });
        plugin = new Plugin();
        Plugin.backend = backend;
        backend.addExtensionHandler("http://jabber.org/protocol/si", (ExtensionHandler)new IQSiHandler());
        backend.addExtensionHandler("http://jabber.org/protocol/si/profile/file-transfer", (ExtensionHandler)new XSiFileTransferHandler());
        backend.addExtensionHandler("http://jabber.org/protocol/feature-neg", new ExtensionHandler(){
            private XData data;

            public void startHandling(Attributes attr) {
                this.data = null;
            }

            public void addExtension(Extension extension) {
                if (extension instanceof XData) {
                    this.data = (XData)extension;
                }
            }

            public Extension build() throws InstantiationException {
                return this.data;
            }
        });
        backend.addExtensionHandler("http://jabber.org/protocol/ibb", (ExtensionHandler)new IBBHandler());
        backend.addExtensionHandler("http://jabber.org/protocol/bytestreams", (ExtensionHandler)new Socks5Handler());
        Socks5Send.initProxies(backend);
        backend.getMain().getOnlinePanel().setTransferHandler((TransferHandler)new FileTransferhandler());
    }

    public static void addGetFile(GetFileWindow w, JID jid, String id) {
        Plugin.plugin.fileWindows.put(jid, w);
    }

    public static GetFileWindow getGetFile(JID jid, String sid) {
        return (GetFileWindow)Plugin.plugin.fileWindows.remove(jid);
    }

    public static void unload(Backend backend) {
        backend.getMain().removeFromRosterMenu(String.valueOf(I18N.gettext((String)"filetransfer.Transfer_File")) + "...");
        backend.removeExtensionHandler("http://jabber.org/protocol/ibb");
        backend.removeExtensionHandler("http://jabber.org/protocol/si");
        backend.removeExtensionHandler("http://jabber.org/protocol/si/profile/file-transfer");
        backend.removeExtensionHandler("http://jabber.org/protocol/feature-neg");
        plugin = null;
    }

    public void unload() {
    }

    public static String sha(String sid, JID initiator, JID target) {
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        sha.update(sid.getBytes());
        sha.update(Plugin.stringPrep(initiator).getBytes());
        return Utils.toString((byte[])sha.digest(Plugin.stringPrep(target).getBytes()));
    }

    private static String stringPrep(JID jid) {
        StringBuffer j = new StringBuffer();
        if (jid.getUser() != null) {
            j.append(jid.getUser().toLowerCase());
            j.append("@");
        }
        j.append(jid.getDomain().toLowerCase());
        if (jid.getResource() != null) {
            j.append("/");
            j.append(jid.getResource());
        }
        return j.toString();
    }

    public static String getIP() {
        try {
            Enumeration<NetworkInterface> interfaceEnum = NetworkInterface.getNetworkInterfaces();
            while (interfaceEnum.hasMoreElements()) {
                NetworkInterface n = interfaceEnum.nextElement();
                Enumeration<InetAddress> ipEnum = n.getInetAddresses();
                while (ipEnum.hasMoreElements()) {
                    InetAddress ip = ipEnum.nextElement();
                    if (!(ip instanceof Inet4Address) || ip.isLoopbackAddress() || ip.isSiteLocalAddress()) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected static JFileChooser getFileChooser() {
        return fileChooser;
    }

    public static String getSizeText(long size) {
        if (size < 1024L) {
            return String.valueOf(size) + " bytes";
        }
        NumberFormat n = NumberFormat.getNumberInstance();
        n.setMaximumFractionDigits(2);
        double s = (double)size / 1024.0;
        if (s < 1024.0) {
            return String.valueOf(n.format(s)) + " kB";
        }
        if ((s /= 1024.0) < 1024.0) {
            return String.valueOf(n.format(s)) + " MB";
        }
        return String.valueOf(n.format(s /= 1024.0)) + " GB";
    }

    private static class FileTransferhandler
    extends TransferHandler {
        private FileTransferhandler() {
        }

        public boolean canImport(JComponent comp, DataFlavor[] flavors) {
            int i = 0;
            while (i < flavors.length) {
                if (flavors[i].equals(DataFlavor.javaFileListFlavor)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean importData(JComponent comp, Transferable t) {
            JID to;
            Object o = ((JTree)comp).getLastSelectedPathComponent();
            if (o instanceof JIDStatus) {
                to = ((JIDStatus)o).getCompleteJID();
            } else {
                if (!(o instanceof PrimaryJIDStatus)) return false;
                PrimaryJIDStatus p = (PrimaryJIDStatus)o;
                to = p.getJIDPrimaryStatus().getCompleteJID();
            }
            if (!t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return false;
            }
            try {
                File file;
                Collection files = (Collection)t.getTransferData(DataFlavor.javaFileListFlavor);
                if (files == null) return false;
                if (files.size() == 0) {
                    return false;
                }
                Iterator i = files.iterator();
                while (i.hasNext()) {
                    file = (File)i.next();
                    if (file.isFile()) continue;
                    Popups.errorPopup((String)I18N.gettext((String)"filetransfer.Can_not_transfer_directories"), (String)I18N.gettext((String)"main.error.Error"));
                    return false;
                }
                i = files.iterator();
                while (i.hasNext()) {
                    file = (File)i.next();
                    new SendFileWindow(backend, to, file).setVisible(true);
                }
                return true;
            }
            catch (UnsupportedFlavorException e) {
                System.out.println("unsupported data");
                return false;
            }
            catch (IOException e) {
                System.out.println("IOException");
            }
            return false;
        }
    }
}

