/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.titlescroller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JFrame;
import javax.swing.Timer;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.plugins.Notifiers;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.util.Preferences;

public class Plugin
implements Plugins,
ActionListener,
Notifiers {
    public static final String VERSION = "0.1";
    public static final String DESCRIPTION = "titlescroller.Scrolls_the_window_title_of_chat_windows_on_new_messages";
    public static final String MIN_JETI_VERSION = "0.5.3";
    public static final String NAME = "titlescroller";
    public static final String ABOUT = "by E.S. de boer";
    public static final String PARENT = "Notifiers";
    private Timer timer;
    private StringBuffer tekst;
    private int teller;
    private int currentChar;
    private long maxScrollTime;
    private long startTime;
    private JFrame frame;
    private String title;
    private WindowFocusListener focusListener = new WindowFocusListener(){

        public void windowGainedFocus(WindowEvent windowEvent) {
            Plugin.this.stop();
        }

        public void windowLostFocus(WindowEvent windowEvent) {
        }
    };

    public static void init(Backend backend) {
    }

    public void unload() {
        if (this.frame != null) {
            this.frame.removeWindowFocusListener(this.focusListener);
            this.frame.setTitle(this.title);
        }
        this.timer.stop();
        this.timer = null;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void init(JFrame jFrame, String string) {
        this.frame = jFrame;
        this.title = string;
        this.maxScrollTime = Preferences.getInteger((String)NAME, (String)"scrolltime", (int)120);
        this.maxScrollTime *= 1000L;
        if (this.timer == null) {
            this.timer = new Timer(Preferences.getInteger((String)NAME, (String)"scrollspeed", (int)200), this);
        }
        jFrame.addWindowFocusListener(this.focusListener);
    }

    public void start(String string) {
        if (!this.frame.isFocused()) {
            this.timer.stop();
            this.tekst = new StringBuffer(string);
            this.startTime = System.currentTimeMillis();
            this.currentChar = 0;
            this.teller = 0;
            this.timer.restart();
        }
    }

    public void stop() {
        if (this.timer.isRunning()) {
            this.timer.stop();
            this.frame.setTitle(this.title);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.maxScrollTime > 0L && System.currentTimeMillis() - this.startTime >= this.maxScrollTime) {
            this.stop();
        } else {
            this.frame.setTitle(this.tekst.substring(this.currentChar));
            ++this.currentChar;
            if (this.currentChar > this.tekst.length()) {
                this.currentChar = 0;
            }
            ++this.teller;
        }
    }
}

