/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.xhtml;

import java.awt.Color;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.XExtension;
import nu.fw.jeti.plugins.Word;

public class XHTML
extends Extension
implements XExtension {
    private String body;
    private List wordList;
    private static final char[] HEX_DIG = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public XHTML() {
    }

    public XHTML(List list) {
        this.wordList = list;
    }

    public XHTML(String string, List list) {
        this.body = string;
        this.wordList = list;
    }

    public List getWordList() {
        return this.wordList;
    }

    public String getBody() {
        return this.body;
    }

    public void appendToXML(StringBuffer stringBuffer) {
        if (this.body == null) {
            this.generateBody();
        }
        stringBuffer.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        stringBuffer.append(this.body);
        stringBuffer.append("</html>");
    }

    private void generateBody() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<body>");
        this.parseElement(stringBuffer, 0, this.wordList.size(), false);
        stringBuffer.append("</body>");
        this.body = stringBuffer.toString();
    }

    private void parseElement(StringBuffer stringBuffer, int n, int n2, boolean bl) {
        Object object;
        if (n >= n2) {
            return;
        }
        MutableAttributeSet mutableAttributeSet = ((Word)this.wordList.get(n)).getAttributes();
        int n3 = 0;
        if (mutableAttributeSet != null) {
            if (mutableAttributeSet.isDefined(StyleConstants.FontFamily)) {
                object = "font-family: " + StyleConstants.getFontFamily(mutableAttributeSet);
                n3 = this.addStyle(stringBuffer, n, n2, bl, mutableAttributeSet, (String)object, StyleConstants.FontFamily);
                bl = false;
            } else if (mutableAttributeSet.isDefined(StyleConstants.FontSize)) {
                object = " font-size: " + StyleConstants.getFontSize(mutableAttributeSet) + "pt";
                n3 = this.addStyle(stringBuffer, n, n2, bl, mutableAttributeSet, (String)object, StyleConstants.FontSize);
                bl = false;
            } else if (mutableAttributeSet.isDefined(StyleConstants.Foreground)) {
                object = this.colorToHexString((Color)mutableAttributeSet.getAttribute(StyleConstants.Foreground));
                String string = " color: #" + (String)object;
                n3 = this.addStyle(stringBuffer, n, n2, bl, mutableAttributeSet, string, StyleConstants.Foreground);
                bl = false;
            } else if (mutableAttributeSet.isDefined(StyleConstants.Background)) {
                object = this.colorToHexString((Color)mutableAttributeSet.getAttribute(StyleConstants.Background));
                String string = " background-color: #" + (String)object;
                n3 = this.addStyle(stringBuffer, n, n2, bl, mutableAttributeSet, string, StyleConstants.Background);
                bl = false;
            } else if (mutableAttributeSet.isDefined(StyleConstants.StrikeThrough)) {
                object = " text-decoration: line-through";
                n3 = this.addStyle(stringBuffer, n, n2, bl, mutableAttributeSet, (String)object, StyleConstants.StrikeThrough);
                bl = false;
            } else if (mutableAttributeSet.containsAttribute(StyleConstants.Underline, Boolean.TRUE)) {
                object = " text-decoration: underline";
                n3 = this.addStyle(stringBuffer, n, n2, bl, mutableAttributeSet, (String)object, StyleConstants.Underline);
                bl = false;
            } else if (StyleConstants.isBold(mutableAttributeSet)) {
                if (bl) {
                    stringBuffer.append("; margin:0 \">");
                }
                bl = false;
                stringBuffer.append("<strong>");
                object = mutableAttributeSet.getAttribute(StyleConstants.Bold);
                n3 = this.getStyleEnd(StyleConstants.Bold, object, n, n2);
                this.parseElement(stringBuffer, n, n3, false);
                stringBuffer.append("</strong>");
            } else if (StyleConstants.isItalic(mutableAttributeSet)) {
                if (bl) {
                    stringBuffer.append("; margin:0 \">");
                }
                bl = false;
                stringBuffer.append("<em>");
                object = mutableAttributeSet.getAttribute(StyleConstants.Italic);
                n3 = this.getStyleEnd(StyleConstants.Italic, object, n, n2);
                this.parseElement(stringBuffer, n, n3, false);
                stringBuffer.append("</em>");
            }
        }
        if (bl) {
            stringBuffer.append("; margin:0 \">");
        }
        if (n3 == 0) {
            object = new StringBuffer();
            XHTML.escapeString((StringBuffer)object, (String)this.wordList.get(n).toString());
            stringBuffer.append((StringBuffer)object);
            if (n + 1 < n2) {
                this.parseElement(stringBuffer, n + 1, n2, false);
            }
        } else if (n3 < n2) {
            this.parseElement(stringBuffer, n3, n2, false);
        }
    }

    private int addStyle(StringBuffer stringBuffer, int n, int n2, boolean bl, AttributeSet attributeSet, String string, Object object) {
        Object object2 = attributeSet.getAttribute(object);
        int n3 = this.getStyleEnd(object, object2, n, n2);
        if (bl) {
            if (n3 < n2) {
                stringBuffer.append("\"><span style=\"");
            } else {
                stringBuffer.append(';');
            }
        } else {
            stringBuffer.append("<span style=\"");
        }
        stringBuffer.append(string);
        this.parseElement(stringBuffer, n, n3, true);
        if (!bl) {
            stringBuffer.append("</span>");
        }
        return n3;
    }

    private int getStyleEnd(Object object, Object object2, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            MutableAttributeSet mutableAttributeSet = ((Word)this.wordList.get(i)).getAttributes();
            if (mutableAttributeSet == null) {
                return i;
            }
            if (mutableAttributeSet.isDefined(object)) {
                if (!object2.equals(mutableAttributeSet.getAttribute(object))) continue;
                mutableAttributeSet.removeAttribute(object);
                continue;
            }
            return i;
        }
        return n2;
    }

    public String colorToHexString(Color color) {
        int n = color.getRGB();
        char[] cArray = new char[6];
        for (int i = 0; i < 6; ++i) {
            cArray[5 - i] = HEX_DIG[n & 0xF];
            n >>= 4;
        }
        return new String(cArray);
    }
}

