/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.groupchatalerter;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.plugins.PreferencesPanel;
import nu.fw.jeti.plugins.groupchat.Plugin;
import nu.fw.jeti.plugins.groupchatalerter.Alerter;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class PrefPanel
extends PreferencesPanel {
    private Backend backend;
    private JTextField txtStatusMessage;
    private JCheckBox chkAlertOnMinimize;
    private JCheckBox chkChangeStatus;

    public PrefPanel(Backend backend) {
        this.backend = backend;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 2, 0, 2);
        gridBagConstraints.weighty = 0.0;
        for (int i = 0; i < 6; ++i) {
            this.createRuleBlock(gridBagConstraints, i);
        }
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.add(new JPanel(), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.chkAlertOnMinimize = new JCheckBox(I18N.gettext((String)"groupchatalerter.Enable_Alerter_on_minimize"));
        this.chkAlertOnMinimize.setSelected(Preferences.getBoolean((String)"groupchatalerter", (String)"alerterOnMinimize", (boolean)false));
        this.add(this.chkAlertOnMinimize, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.chkChangeStatus = new JCheckBox(I18N.gettext((String)"groupchatalerter.Change_alerter_status_when_extended_away"));
        this.chkChangeStatus.setSelected(Preferences.getBoolean((String)"groupchatalerter", (String)"changeStatus", (boolean)false));
        this.add(this.chkChangeStatus, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        JLabel jLabel = new JLabel(I18N.gettext((String)"groupchatalerter.Alerter_Status_Message"));
        this.add(jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.txtStatusMessage = new JTextField(Preferences.getString((String)"groupchatalerter", (String)"alerterStatusMessage", (String)"alerter"));
        this.add(this.txtStatusMessage, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        jLabel = new JLabel(I18N.gettext((String)"groupchatalerter.Test_Match_On"));
        jLabel.setToolTipText(I18N.gettext((String)"groupchatalerter.Test_rule_to_test_if_the_rule_works_on_test_text"));
        this.add(jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        final JTextField jTextField = new JTextField();
        this.add(jTextField, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        jLabel = new JLabel(I18N.gettext((String)"groupchatalerter.Test_Text"));
        jLabel.setToolTipText(I18N.gettext((String)"groupchatalerter.Test_text_to_test_Test_Match_rule_on"));
        this.add(jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        final JTextField jTextField2 = new JTextField();
        this.add(jTextField2, gridBagConstraints);
        JButton jButton = new JButton(I18N.gettext((String)"groupchatalerter.Test"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Matcher matcher = Pattern.compile(jTextField.getText(), 2).matcher(jTextField2.getText());
                    jTextField2.requestFocus();
                    if (matcher.find()) {
                        jTextField2.setCaretPosition(matcher.start());
                        jTextField2.moveCaretPosition(matcher.end());
                    } else {
                        jTextField2.setCaretPosition(0);
                        jTextField2.moveCaretPosition(0);
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    JOptionPane.showMessageDialog((Component)((Object)PrefPanel.this), patternSyntaxException.getMessage());
                    return;
                }
            }
        });
        this.add(jButton, gridBagConstraints);
    }

    private void createRuleBlock(GridBagConstraints gridBagConstraints, int n) {
        RuleBlock ruleBlock = new RuleBlock(n);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        this.add(ruleBlock.ruleEnabled, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.add(ruleBlock.room, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        JLabel jLabel = new JLabel(I18N.gettext((String)"groupchatalerter.Match_on"));
        jLabel.setToolTipText(I18N.gettext((String)"groupchatalerter.Rule_what_to_match,_use_keywords_separated_by_the_|_character,_regular_expressions_are_supported"));
        this.add(jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.add(ruleBlock.rule, gridBagConstraints);
    }

    public void savePreferences() {
        Preferences.putString((String)"groupchatalerter", (String)"alerterStatusMessage", (String)this.txtStatusMessage.getText());
        Preferences.putBoolean((String)"groupchatalerter", (String)"alerterOnMinimize", (boolean)this.chkAlertOnMinimize.isSelected());
        Preferences.putBoolean((String)"groupchatalerter", (String)"changeStatus", (boolean)this.chkChangeStatus.isSelected());
    }

    class RuleBlock {
        private JCheckBox ruleEnabled;
        private JTextField room;
        private JTextField rule;
        private int order;

        RuleBlock(int n) {
            this.order = n;
            this.ruleEnabled = new JCheckBox(I18N.gettext((String)"groupchatalerter.Groupchat_room"));
            this.ruleEnabled.setToolTipText(I18N.gettext((String)"groupchatalerter.Room_to_monitor_Add_/nickname_to_set_your_nickname"));
            boolean bl = Preferences.getBoolean((String)"groupchatalerter", (String)("ruleEnabled" + n), (boolean)false);
            this.ruleEnabled.setSelected(bl);
            this.ruleEnabled.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (RuleBlock.this.ruleEnabled.isSelected()) {
                        RuleBlock.this.room.setEditable(false);
                        try {
                            if (RuleBlock.this.room.getText().equals("")) {
                                return;
                            }
                            JID jID = JID.checkedJIDFromString((String)RuleBlock.this.room.getText());
                            Preferences.putString((String)"groupchatalerter", (String)("room" + RuleBlock.this.order), (String)RuleBlock.this.room.getText());
                            try {
                                Pattern.compile(RuleBlock.this.rule.getText());
                            }
                            catch (PatternSyntaxException patternSyntaxException) {
                                JOptionPane.showMessageDialog((Component)((Object)PrefPanel.this), patternSyntaxException.getMessage());
                                RuleBlock.this.ruleEnabled.setSelected(false);
                                return;
                            }
                            JID jID2 = Plugin.getGroupchatJID((JID)jID);
                            if (jID2 != null) {
                                jID = jID2;
                            }
                            nu.fw.jeti.plugins.groupchatalerter.Plugin.addAlerter(new Alerter(PrefPanel.this.backend, jID, RuleBlock.this.rule.getText()), jID);
                            Preferences.putBoolean((String)"groupchatalerter", (String)("ruleEnabled" + RuleBlock.this.order), (boolean)RuleBlock.this.ruleEnabled.isSelected());
                        }
                        catch (InstantiationException instantiationException) {
                            JOptionPane.showMessageDialog((Component)((Object)PrefPanel.this), instantiationException.getMessage());
                            RuleBlock.this.ruleEnabled.setSelected(false);
                        }
                    } else {
                        Preferences.putBoolean((String)"groupchatalerter", (String)("ruleEnabled" + RuleBlock.this.order), (boolean)RuleBlock.this.ruleEnabled.isSelected());
                        nu.fw.jeti.plugins.groupchatalerter.Plugin.removeAlerter(JID.jidFromString((String)RuleBlock.this.room.getText()));
                        RuleBlock.this.room.setEditable(true);
                    }
                }
            });
            this.room = new JTextField(Preferences.getString((String)"groupchatalerter", (String)("room" + n), null));
            this.rule = new JTextField(Preferences.getString((String)"groupchatalerter", (String)("rule" + n), null));
            this.rule.addFocusListener(new FocusListener(){
                private String ruleText;

                public void focusLost(FocusEvent focusEvent) {
                    JID jID;
                    Preferences.putString((String)"groupchatalerter", (String)("rule" + RuleBlock.this.order), (String)RuleBlock.this.rule.getText());
                    Preferences.putString((String)"groupchatalerter", (String)("room" + RuleBlock.this.order), (String)RuleBlock.this.room.getText());
                    if (RuleBlock.this.ruleEnabled.isSelected() && !RuleBlock.this.rule.getText().equals(this.ruleText)) {
                        try {
                            Pattern.compile(RuleBlock.this.rule.getText());
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            JOptionPane.showMessageDialog((Component)((Object)PrefPanel.this), patternSyntaxException.getDescription());
                            return;
                        }
                    }
                    if (nu.fw.jeti.plugins.groupchatalerter.Plugin.isMonitoring(jID = JID.jidFromString((String)RuleBlock.this.room.getText()))) {
                        nu.fw.jeti.plugins.groupchatalerter.Plugin.updateRule(jID, RuleBlock.this.rule.getText());
                    }
                }

                public void focusGained(FocusEvent focusEvent) {
                    this.ruleText = RuleBlock.this.rule.getText();
                }
            });
            if (this.ruleEnabled.isSelected()) {
                this.room.setEditable(false);
            }
        }
    }
}

