/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.translate;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class Language
implements Serializable {
    private String shortName;
    private String fullName;
    private static final Hashtable langs = new Hashtable();
    public static final Language ZH = new Language("ZH", "Chinese-simp");
    public static final Language ZT = new Language("ZT", "Chinese-trad");
    public static final Language EN = new Language("EN", "English");
    public static final Language NL = new Language("NL", "Dutch");
    public static final Language FR = new Language("FR", "French");
    public static final Language DE = new Language("DE", "German");
    public static final Language EL = new Language("EL", "Greek");
    public static final Language IT = new Language("IT", "Italian");
    public static final Language JA = new Language("JA", "Japanese");
    public static final Language KO = new Language("KO", "Korean");
    public static final Language PT = new Language("PT", "Portuguese");
    public static final Language RU = new Language("RU", "Russian");
    public static final Language ES = new Language("ES", "Spanish");

    public static Language forShortName(String string) {
        return (Language)langs.get(string);
    }

    public static Language forFullName(String string) {
        Enumeration enumeration = langs.elements();
        while (enumeration.hasMoreElements()) {
            Language language = (Language)enumeration.nextElement();
            if (!language.getFullName().equals(string)) continue;
            return language;
        }
        return null;
    }

    protected Language(String string, String string2) {
        this.shortName = string;
        this.fullName = string2;
        langs.put(string, this);
    }

    public String toString() {
        return this.fullName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String string) {
        this.fullName = string;
    }

    public String getShortName() {
        return this.shortName;
    }

    public static Enumeration getAllLanguages() {
        return langs.elements();
    }

    public void setShortName(String string) {
        this.shortName = string;
    }

    private Object readResolve() throws ObjectStreamException {
        return Language.forShortName(this.shortName);
    }
}

