/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

public class Util {
    public static String replace(String value, String oldPart, String newPart) {
        if (value == null || value.length() == 0 || oldPart == null || oldPart.length() == 0) {
            return value;
        }
        int oldPartLength = oldPart.length();
        String oldValue = value;
        StringBuffer retValue = new StringBuffer();
        int pos = oldValue.indexOf(oldPart);
        while (pos != -1) {
            retValue.append(oldValue.substring(0, pos));
            if (newPart != null && newPart.length() > 0) {
                retValue.append(newPart);
            }
            oldValue = oldValue.substring(pos + oldPartLength);
            pos = oldValue.indexOf(oldPart);
        }
        retValue.append(oldValue);
        return retValue.toString();
    }

    public static String maskHTML(String content) {
        if (content == null || content.length() == 0 || content.equals(" ")) {
            return "&nbsp";
        }
        String temp = Util.replace(content, "<", "&lt;");
        temp = Util.replace(temp, ">", "&gt;");
        temp = Util.replace(temp, "\"", "&quot;");
        temp = Util.replace(temp, "&", "&amp;");
        return temp;
    }

    public static int getCount(String string, char countChar) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        int counter = 0;
        char[] array = string.toCharArray();
        int i = 0;
        while (i < array.length) {
            if (array[i] == countChar) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    public static int findIndexOf(String str, char search) {
        return Util.findIndexOf(str, search, search);
    }

    public static int findIndexOf(String str, char search1, char search2) {
        if (str == null) {
            return -1;
        }
        int endIndex = -1;
        int parCount = 0;
        boolean ignoringText = false;
        int size = str.length();
        while (++endIndex < size) {
            char c = str.charAt(endIndex);
            if (c == '\'') {
                ignoringText = !ignoringText;
                continue;
            }
            if (ignoringText) continue;
            if (parCount == 0 && (c == search1 || c == search2)) {
                return endIndex;
            }
            if (c == ')') {
                --parCount;
                continue;
            }
            if (c != '(') continue;
            ++parCount;
        }
        return -1;
    }

    public static int findIndexOf(String str, String search) {
        if (str == null || search == null || search.length() == 0) {
            return -1;
        }
        int endIndex = -1;
        int parCount = 0;
        boolean ignoringText = false;
        int size = str.length();
        while (++endIndex < size) {
            char c = str.charAt(endIndex);
            if (c == '\'') {
                ignoringText = !ignoringText;
                continue;
            }
            if (ignoringText) continue;
            if (parCount == 0 && c == search.charAt(0)) {
                if (!str.substring(endIndex).startsWith(search)) continue;
                return endIndex;
            }
            if (c == ')') {
                --parCount;
                continue;
            }
            if (c != '(') continue;
            ++parCount;
        }
        return -1;
    }

    public static String toHex(byte b) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] array = new char[]{hexDigit[b >> 4 & 0xF], hexDigit[b & 0xF]};
        return new String(array);
    }

    public static String toHex(char c) {
        byte hi = (byte)(c >>> 8);
        byte lo = (byte)(c & 0xFF);
        return Util.toHex(hi) + Util.toHex(lo);
    }
}

