/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Properties;
import org.compiere.util.IniDialog;
import org.compiere.util.Language;
import org.compiere.util.Secure;

public final class Ini
implements Serializable {
    public static final String P_UID = "ApplicationUserID";
    public static final String P_PWD = "ApplicationPassword";
    public static final String P_DEBUGLEVEL = "DebugLevel";
    public static final String P_LANGUAGE = "Language";
    public static final String P_INI = "FileNameINI";
    public static final String DEFAULT_UID = "System";
    public static final String DEFAULT_PWD = "System";
    public static final int DEFAULT_DEBUGLEVEL = 0;
    public static final String DEFAULT_LANGUAGE;
    public static final String DEFAULT_INI = "";
    public static final String P_CONNECTION = "Connection";
    public static final String P_OBJECTS = "ServerObjects";
    public static final String DEFAULT_CONNECTION = "";
    public static final boolean DEFAULT_OBJECTS = false;
    public static final String P_UI_LOOK = "UILookFeel";
    public static final String P_UI_THEME = "UITheme";
    public static final String DEFAULT_UI_LOOK = "Compiere";
    public static final String DEFAULT_UI_THEME = "Compiere Theme";
    public static final String P_A_COMMIT = "AutoCommit";
    public static final String P_A_LOGIN = "AutoLogin";
    public static final String P_COMPIERESYS = "CompiereSys";
    public static final String P_SHOW_ACCT = "ShowAcct";
    public static final String P_SHOW_TRL = "ShowTrl";
    public static final String P_OPEN_SOURCE = "OpenSource";
    public static final String P_TEMP_DIR = "TempDir";
    public static final boolean DEFAULT_A_COMMIT = true;
    public static final boolean DEFAULT_A_LOGIN = false;
    public static final boolean DEFAULT_COMPIERESYS = false;
    public static final boolean DEFAULT_SHOW_ACCT = false;
    public static final boolean DEFAULT_SHOW_TRL = false;
    public static final boolean DEFAULT_OPEN_SOURCE = true;
    public static final String DEFAULT_TEMP_DIR = "";
    public static final String P_ROLE = "Role";
    public static final String P_CLIENT = "Client";
    public static final String P_ORG = "Organization";
    public static final String P_PRINTER = "Printer";
    public static final String P_WAREHOUSE = "Warehouse";
    public static final String P_TODAY = "Today";
    public static final String DEFAULT_ROLE = "";
    public static final String DEFAULT_CLIENT = "";
    public static final String DEFAULT_ORG = "";
    public static final String DEFAULT_PRINTER = "";
    public static final String DEFAULT_WAREHOUSE = "";
    public static final Timestamp DEFAULT_TODAY;
    private static final String P_WARNING = "Warning";
    private static final String P_WARNING_de = "WarningD";
    private static final String DEFAULT_WARNING = "Do_not_change_any_of_the_data_as_they_will_have_undocumented_side_effects.";
    private static final String DEFAULT_WARNING_de = "Einstellungen_nicht_aendern,_da_diese_undokumentierte_Nebenwirkungen_haben.";
    private static final String[] PROPERTIES;
    private static final String[] VALUES;
    private static Properties s_prop;
    public static final String ENV_PREFIX = "env.";
    public static final String COMPIERE_HOME = "COMPIERE_HOME";
    private static boolean s_isClient;

    public static void saveProperties(boolean tryUserHome) {
        String fileName = Ini.getFileName(tryUserHome);
        FileOutputStream fos = null;
        try {
            File f = new File(fileName);
            fos = new FileOutputStream(f);
            s_prop.store(fos, DEFAULT_UI_LOOK);
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            System.err.println("Ini.saveProperties - Cannot save Properties to " + fileName + " - " + e.toString());
            return;
        }
        catch (Throwable t) {
            System.err.println("Ini.saveProperties - Cannot save Properties to " + fileName + " - " + t.toString());
            return;
        }
    }

    public static void loadProperties(boolean reload) {
        if (reload || s_prop.size() == 0) {
            Ini.loadProperties(Ini.getFileName(true));
        }
    }

    public static boolean loadProperties(String filename) {
        System.out.println("Ini.loadProperties: " + filename);
        boolean loadOK = true;
        boolean firstTime = false;
        s_prop = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
            s_prop.load(fis);
            fis.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Ini.loadProperties " + filename + " not found");
            loadOK = false;
        }
        catch (Exception e) {
            System.err.println("Ini.loadProperties " + filename + " - " + e.toString());
            loadOK = false;
        }
        catch (Throwable t) {
            System.err.println("Ini.loadProperties " + filename + " - " + t.toString());
            loadOK = false;
        }
        if (!loadOK) {
            firstTime = true;
            if (!IniDialog.accept()) {
                System.exit(10);
            }
        }
        int i = 0;
        while (i < PROPERTIES.length) {
            if (VALUES[i].length() > 0) {
                Ini.checkProperty(PROPERTIES[i], VALUES[i]);
            }
            ++i;
        }
        String tempDir = System.getProperty("java.io.tmpdir");
        if (tempDir == null || tempDir.length() == 1) {
            tempDir = Ini.getCompiereHome();
        }
        if (tempDir == null) {
            tempDir = "";
        }
        Ini.checkProperty(P_TEMP_DIR, tempDir);
        if (!loadOK) {
            Ini.saveProperties(true);
        }
        return firstTime;
    }

    private static String checkProperty(String key, String def) {
        String result = s_prop.getProperty(key, Secure.encrypt(def));
        s_prop.setProperty(key, result);
        return result;
    }

    private static String getFileName(boolean tryUserHome) {
        String home;
        String base = null;
        if (tryUserHome) {
            base = System.getProperty("user.home");
        }
        if (!(s_isClient && base != null && base.length() != 0 || (home = Ini.getCompiereHome()) == null)) {
            base = home;
        }
        if (base != null && !base.endsWith(File.separator)) {
            base = base + File.separator;
        }
        if (base == null) {
            base = "";
        }
        return base + "Compiere.properties";
    }

    public static void setProperty(String key, String value) {
        if (s_prop == null) {
            s_prop = new Properties();
        }
        if (key.equals(P_WARNING) || key.equals(P_WARNING_de)) {
            s_prop.setProperty(key, value);
        } else {
            s_prop.setProperty(key, Secure.encrypt(value));
        }
    }

    public static void setProperty(String key, boolean value) {
        Ini.setProperty(key, value ? "Y" : "N");
    }

    public static void setProperty(String key, int value) {
        Ini.setProperty(key, String.valueOf(value));
    }

    public static String getProperty(String key) {
        if (key == null) {
            return "";
        }
        String retStr = s_prop.getProperty(key, "");
        return Secure.decrypt(retStr);
    }

    public static boolean getPropertyBool(String key) {
        return Ini.getProperty(key).equals("Y");
    }

    public static Properties getProperties() {
        return s_prop;
    }

    public static String getAsString() {
        StringBuffer buf = new StringBuffer("Ini - ");
        Enumeration<Object> e = s_prop.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            buf.append(key).append("=");
            buf.append(Ini.getProperty(key)).append("; ");
        }
        return buf.toString();
    }

    public static boolean isClient() {
        return s_isClient;
    }

    public static void setClient(boolean client) {
        s_isClient = client;
    }

    public static String getCompiereHome() {
        String env = System.getProperty("env.COMPIERE_HOME");
        if (env == null) {
            env = System.getProperty(COMPIERE_HOME);
        }
        return env;
    }

    static {
        P_UID = P_UID;
        P_PWD = P_PWD;
        P_DEBUGLEVEL = P_DEBUGLEVEL;
        P_LANGUAGE = P_LANGUAGE;
        P_INI = P_INI;
        DEFAULT_UID = "System";
        DEFAULT_PWD = "System";
        DEFAULT_DEBUGLEVEL = 0;
        DEFAULT_LANGUAGE = Language.getName(System.getProperty("user.language") + "_" + System.getProperty("user.country"));
        DEFAULT_INI = "";
        P_CONNECTION = P_CONNECTION;
        P_OBJECTS = P_OBJECTS;
        DEFAULT_CONNECTION = "";
        DEFAULT_OBJECTS = false;
        P_UI_LOOK = P_UI_LOOK;
        P_UI_THEME = P_UI_THEME;
        DEFAULT_UI_LOOK = DEFAULT_UI_LOOK;
        DEFAULT_UI_THEME = DEFAULT_UI_THEME;
        P_A_COMMIT = P_A_COMMIT;
        P_A_LOGIN = P_A_LOGIN;
        P_COMPIERESYS = P_COMPIERESYS;
        P_SHOW_ACCT = P_SHOW_ACCT;
        P_SHOW_TRL = P_SHOW_TRL;
        P_OPEN_SOURCE = P_OPEN_SOURCE;
        P_TEMP_DIR = P_TEMP_DIR;
        DEFAULT_A_COMMIT = true;
        DEFAULT_A_LOGIN = false;
        DEFAULT_COMPIERESYS = false;
        DEFAULT_SHOW_ACCT = false;
        DEFAULT_SHOW_TRL = false;
        DEFAULT_OPEN_SOURCE = true;
        DEFAULT_TEMP_DIR = "";
        P_ROLE = P_ROLE;
        P_CLIENT = P_CLIENT;
        P_ORG = P_ORG;
        P_PRINTER = P_PRINTER;
        P_WAREHOUSE = P_WAREHOUSE;
        P_TODAY = P_TODAY;
        DEFAULT_ROLE = "";
        DEFAULT_CLIENT = "";
        DEFAULT_ORG = "";
        DEFAULT_PRINTER = "";
        DEFAULT_WAREHOUSE = "";
        DEFAULT_TODAY = new Timestamp(System.currentTimeMillis());
        P_WARNING = P_WARNING;
        P_WARNING_de = P_WARNING_de;
        DEFAULT_WARNING = DEFAULT_WARNING;
        DEFAULT_WARNING_de = DEFAULT_WARNING_de;
        PROPERTIES = new String[]{P_UID, P_PWD, P_DEBUGLEVEL, P_LANGUAGE, P_INI, P_CONNECTION, P_OBJECTS, P_UI_LOOK, P_UI_THEME, P_A_COMMIT, P_A_LOGIN, P_COMPIERESYS, P_SHOW_ACCT, P_SHOW_TRL, P_OPEN_SOURCE, P_TEMP_DIR, P_ROLE, P_CLIENT, P_ORG, P_PRINTER, P_WAREHOUSE, P_TODAY, P_WARNING, P_WARNING_de};
        VALUES = new String[]{"System", "System", String.valueOf(0), DEFAULT_LANGUAGE, "", "", "N", DEFAULT_UI_LOOK, DEFAULT_UI_THEME, "Y", "N", "N", "N", "N", "Y", "", "", "", "", "", "", DEFAULT_TODAY.toString(), DEFAULT_WARNING, DEFAULT_WARNING_de};
        s_prop = new Properties();
        ENV_PREFIX = ENV_PREFIX;
        COMPIERE_HOME = COMPIERE_HOME;
        s_isClient = true;
    }
}

