/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.plaf;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalTheme;
import org.compiere.plaf.ColorBlind;
import org.compiere.plaf.CompiereColor;
import org.compiere.plaf.CompierePanelUI;
import org.compiere.util.Ini;
import sun.awt.AppContext;

public class CompiereTheme
extends MetalTheme {
    public static final String NAME = "Compiere Theme";
    protected static ColorUIResource primary0;
    protected static ColorUIResource primary1;
    protected static ColorUIResource primary2;
    protected static ColorUIResource primary3;
    protected final ColorUIResource secondary0 = new ColorUIResource(0, 0, 0);
    protected static ColorUIResource secondary1;
    protected static ColorUIResource secondary2;
    protected static ColorUIResource secondary3;
    protected final ColorUIResource secondary4 = new ColorUIResource(255, 255, 255);
    protected static ColorUIResource black;
    protected static ColorUIResource white;
    protected static ColorUIResource mandatory;
    protected static ColorUIResource error;
    protected static ColorUIResource inactive;
    protected static ColorUIResource info;
    protected static ColorUIResource txt_ok;
    protected static ColorUIResource txt_error;
    protected static FontUIResource controlFont;
    protected static FontUIResource systemFont;
    protected static FontUIResource userFont;
    protected static FontUIResource smallFont;
    protected static FontUIResource windowFont;
    protected static FontUIResource menuFont;
    public static final String FONT_DEFAULT = "Dialog";
    public static final int FONT_SIZE = 12;
    private static final String P_Primary1 = "#ColorPrimary1";
    private static final String P_Primary2 = "#ColorPrimary2";
    private static final String P_Primary3 = "#ColorPrimary3";
    private static final String P_Secondary1 = "#ColorSecondary1";
    private static final String P_Secondary2 = "#ColorSecondary2";
    private static final String P_Secondary3 = "#ColorSecondary3";
    private static final String P_Black = "#ColorBlack";
    private static final String P_White = "#ColorWhite";
    private static final String P_Error = "#ColorError";
    private static final String P_Info = "#ColorInfo";
    private static final String P_Mandatory = "#ColorMandatory";
    private static final String P_Inactive = "#ColorInactive";
    private static final String P_Txt_OK = "#ColorTextOK";
    private static final String P_Txt_Error = "#ColorTextError";
    private static final String P_Control = "#FontControl";
    private static final String P_System = "#FontSystem";
    private static final String P_User = "#FontUser";
    private static final String P_Small = "#FontSmall";
    private static final String P_Window = "#FontWindow";
    private static final String P_Menu = "#FontMenu";
    protected static final String P_CompiereColor = "#CompiereColor";

    public String getName() {
        return NAME;
    }

    private static void setDefault() {
        primary1 = new ColorUIResource(102, 102, 153);
        primary2 = new ColorUIResource(153, 153, 204);
        primary3 = new ColorUIResource(204, 204, 255);
        secondary1 = new ColorUIResource(102, 102, 102);
        secondary2 = new ColorUIResource(153, 153, 153);
        secondary3 = new ColorUIResource(204, 204, 204);
        black = new ColorUIResource(Color.black);
        white = new ColorUIResource(Color.white);
        mandatory = new ColorUIResource(224, 224, 255);
        error = new ColorUIResource(255, 204, 204);
        inactive = new ColorUIResource(234, 234, 234);
        info = new ColorUIResource(253, 237, 207);
        txt_ok = new ColorUIResource(51, 51, 102);
        txt_error = new ColorUIResource(204, 0, 0);
        controlFont = null;
        CompiereTheme._getControlTextFont();
        systemFont = null;
        CompiereTheme._getSystemTextFont();
        userFont = null;
        CompiereTheme._getUserTextFont();
        smallFont = null;
        CompiereTheme._getSubTextFont();
        windowFont = null;
        CompiereTheme._getWindowTitleFont();
        menuFont = null;
        CompiereTheme._getMenuTextFont();
    }

    public static void setTheme() {
        AppContext context = AppContext.getAppContext();
        MetalTheme copyFrom = (MetalTheme)context.get("currentMetalTheme");
        CompiereTheme.setTheme(copyFrom);
    }

    public static void setTheme(MetalTheme copyFrom) {
        if (copyFrom == null || copyFrom instanceof CompiereTheme) {
            return;
        }
        primary1 = copyFrom.getPrimaryControlDarkShadow();
        primary2 = copyFrom.getPrimaryControlShadow();
        primary3 = copyFrom.getPrimaryControl();
        secondary1 = copyFrom.getControlDarkShadow();
        secondary2 = copyFrom.getControlShadow();
        secondary3 = copyFrom.getControl();
        CompierePanelUI.setDefaultBackground(new CompiereColor((Color)secondary3, true));
        white = copyFrom.getPrimaryControlHighlight();
        black = copyFrom.getPrimaryControlInfo();
        controlFont = copyFrom.getControlTextFont();
        systemFont = copyFrom.getSystemTextFont();
        userFont = copyFrom.getUserTextFont();
        smallFont = copyFrom.getSubTextFont();
        menuFont = copyFrom.getMenuTextFont();
        windowFont = copyFrom.getWindowTitleFont();
    }

    public ColorUIResource getPrimary1() {
        return ColorBlind.getDichromatColorUIResource(primary1);
    }

    public ColorUIResource getPrimary2() {
        return ColorBlind.getDichromatColorUIResource(primary2);
    }

    public ColorUIResource getPrimary3() {
        return ColorBlind.getDichromatColorUIResource(primary3);
    }

    public ColorUIResource getSecondary0() {
        return ColorBlind.getDichromatColorUIResource(this.secondary0);
    }

    public ColorUIResource getSecondary1() {
        return ColorBlind.getDichromatColorUIResource(secondary1);
    }

    public ColorUIResource getSecondary2() {
        return ColorBlind.getDichromatColorUIResource(secondary2);
    }

    public ColorUIResource getSecondary3() {
        return ColorBlind.getDichromatColorUIResource(secondary3);
    }

    public ColorUIResource getSecondary4() {
        return ColorBlind.getDichromatColorUIResource(this.secondary4);
    }

    public ColorUIResource getBlack() {
        return ColorBlind.getDichromatColorUIResource(black);
    }

    public ColorUIResource getWhite() {
        return ColorBlind.getDichromatColorUIResource(white);
    }

    private static FontUIResource _getControlTextFont() {
        if (controlFont == null) {
            try {
                controlFont = new FontUIResource(Font.getFont("swing.plaf.metal.controlFont", new Font(FONT_DEFAULT, 0, 12)));
            }
            catch (Exception e) {
                controlFont = new FontUIResource(FONT_DEFAULT, 0, 12);
            }
        }
        return controlFont;
    }

    public FontUIResource getControlTextFont() {
        return CompiereTheme._getControlTextFont();
    }

    private static FontUIResource _getSystemTextFont() {
        if (systemFont == null) {
            try {
                systemFont = new FontUIResource(Font.getFont("swing.plaf.metal.systemFont", new Font(FONT_DEFAULT, 0, 12)));
            }
            catch (Exception e) {
                systemFont = new FontUIResource(FONT_DEFAULT, 0, 12);
            }
        }
        return systemFont;
    }

    public FontUIResource getSystemTextFont() {
        return CompiereTheme._getSystemTextFont();
    }

    private static FontUIResource _getUserTextFont() {
        if (userFont == null) {
            try {
                userFont = new FontUIResource(Font.getFont("swing.plaf.metal.userFont", new Font(FONT_DEFAULT, 0, 12)));
            }
            catch (Exception e) {
                userFont = new FontUIResource(FONT_DEFAULT, 0, 12);
            }
        }
        return userFont;
    }

    public FontUIResource getUserTextFont() {
        return CompiereTheme._getUserTextFont();
    }

    private static FontUIResource _getMenuTextFont() {
        if (menuFont == null) {
            try {
                menuFont = new FontUIResource(Font.getFont("swing.plaf.metal.menuFont", new Font(FONT_DEFAULT, 0, 12)));
            }
            catch (Exception e) {
                menuFont = new FontUIResource(FONT_DEFAULT, 0, 12);
            }
        }
        return menuFont;
    }

    public FontUIResource getMenuTextFont() {
        return CompiereTheme._getMenuTextFont();
    }

    private static FontUIResource _getWindowTitleFont() {
        if (windowFont == null) {
            try {
                windowFont = new FontUIResource(Font.getFont("swing.plaf.metal.windowFont", new Font(FONT_DEFAULT, 1, 14)));
            }
            catch (Exception e) {
                windowFont = new FontUIResource(FONT_DEFAULT, 1, 14);
            }
        }
        return windowFont;
    }

    public FontUIResource getWindowTitleFont() {
        return CompiereTheme._getWindowTitleFont();
    }

    private static FontUIResource _getSubTextFont() {
        if (smallFont == null) {
            try {
                smallFont = new FontUIResource(Font.getFont("swing.plaf.metal.smallFont", new Font(FONT_DEFAULT, 0, 10)));
            }
            catch (Exception e) {
                smallFont = new FontUIResource(FONT_DEFAULT, 0, 10);
            }
        }
        return smallFont;
    }

    public FontUIResource getSubTextFont() {
        return CompiereTheme._getSubTextFont();
    }

    public static void save(String fileName) {
        Properties p = new Properties();
        CompiereTheme.save(p);
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            p.store(fos, NAME);
            fos.close();
        }
        catch (Exception e) {
            System.err.println("CompiereTheme.store - " + e.getMessage());
        }
    }

    public static void load(String fileName) {
        Properties p = new Properties();
        try {
            FileInputStream fis = new FileInputStream(fileName);
            p.load(fis);
            fis.close();
        }
        catch (Exception e) {
            System.err.println("CompiereTheme.load - " + e.getMessage());
            return;
        }
        CompiereTheme.load(p);
    }

    public static void save(Properties p) {
        p.setProperty(P_Primary1, CompiereTheme.getColorAsString(primary1));
        p.setProperty(P_Primary2, CompiereTheme.getColorAsString(primary2));
        p.setProperty(P_Primary3, CompiereTheme.getColorAsString(primary3));
        p.setProperty(P_Secondary1, CompiereTheme.getColorAsString(secondary1));
        p.setProperty(P_Secondary2, CompiereTheme.getColorAsString(secondary2));
        p.setProperty(P_Secondary3, CompiereTheme.getColorAsString(secondary3));
        p.setProperty(P_Error, CompiereTheme.getColorAsString(error));
        p.setProperty(P_Info, CompiereTheme.getColorAsString(info));
        p.setProperty(P_Mandatory, CompiereTheme.getColorAsString(mandatory));
        p.setProperty(P_Inactive, CompiereTheme.getColorAsString(inactive));
        p.setProperty(P_White, CompiereTheme.getColorAsString(white));
        p.setProperty(P_Black, CompiereTheme.getColorAsString(black));
        p.setProperty(P_Txt_OK, CompiereTheme.getColorAsString(txt_ok));
        p.setProperty(P_Txt_Error, CompiereTheme.getColorAsString(txt_error));
        p.setProperty(P_Control, controlFont.toString());
        p.setProperty(P_System, systemFont.toString());
        p.setProperty(P_User, userFont.toString());
        p.setProperty(P_Small, smallFont.toString());
        p.setProperty(P_Window, windowFont.toString());
        p.setProperty(P_Menu, menuFont.toString());
        p.setProperty(P_CompiereColor, CompiereColor.getDefaultBackground().toString());
    }

    public static String getColorAsString(Color c) {
        if (c == null) {
            c = SystemColor.control;
        }
        StringBuffer sb = new StringBuffer("[r=").append(c.getRed()).append(",g=").append(c.getGreen()).append(",b=").append(c.getBlue()).append(",a=").append(c.getAlpha()).append("]");
        return sb.toString();
    }

    public static void load() {
        CompiereTheme.load(Ini.getProperties());
    }

    public static void load(Properties p) {
        primary1 = CompiereTheme.parseColor(p.getProperty(P_Primary1), primary1);
        primary2 = CompiereTheme.parseColor(p.getProperty(P_Primary2), primary2);
        primary3 = CompiereTheme.parseColor(p.getProperty(P_Primary3), primary3);
        secondary1 = CompiereTheme.parseColor(p.getProperty(P_Secondary1), secondary1);
        secondary2 = CompiereTheme.parseColor(p.getProperty(P_Secondary2), secondary2);
        secondary3 = CompiereTheme.parseColor(p.getProperty(P_Secondary3), secondary3);
        error = CompiereTheme.parseColor(p.getProperty(P_Error), error);
        info = CompiereTheme.parseColor(p.getProperty(P_Info), info);
        mandatory = CompiereTheme.parseColor(p.getProperty(P_Mandatory), mandatory);
        inactive = CompiereTheme.parseColor(p.getProperty(P_Inactive), inactive);
        white = CompiereTheme.parseColor(p.getProperty(P_White), white);
        black = CompiereTheme.parseColor(p.getProperty(P_Black), black);
        txt_ok = CompiereTheme.parseColor(p.getProperty(P_Txt_OK), txt_ok);
        txt_error = CompiereTheme.parseColor(p.getProperty(P_Txt_Error), txt_error);
        controlFont = CompiereTheme.parseFont(p.getProperty(P_Control), controlFont);
        systemFont = CompiereTheme.parseFont(p.getProperty(P_System), systemFont);
        userFont = CompiereTheme.parseFont(p.getProperty(P_User), userFont);
        smallFont = CompiereTheme.parseFont(p.getProperty(P_Small), smallFont);
        windowFont = CompiereTheme.parseFont(p.getProperty(P_Window), windowFont);
        menuFont = CompiereTheme.parseFont(p.getProperty(P_Menu), menuFont);
        CompiereColor.setDefaultBackground(CompiereColor.parse(p.getProperty(P_CompiereColor)));
    }

    public static void reset(Properties p) {
        p.remove(P_Primary1);
        p.remove(P_Primary2);
        p.remove(P_Primary3);
        p.remove(P_Secondary1);
        p.remove(P_Secondary2);
        p.remove(P_Secondary3);
        p.remove(P_Error);
        p.remove(P_Info);
        p.remove(P_Mandatory);
        p.remove(P_Inactive);
        p.remove(P_White);
        p.remove(P_Black);
        p.remove(P_Txt_OK);
        p.remove(P_Txt_Error);
        p.remove(P_Control);
        p.remove(P_System);
        p.remove(P_User);
        p.remove(P_Small);
        p.remove(P_Window);
        p.remove(P_Menu);
        p.remove(P_CompiereColor);
        p.setProperty("UILookFeel", "Compiere");
        p.setProperty("UITheme", NAME);
        CompiereTheme.setDefault();
        CompiereColor cc = new CompiereColor((Color)secondary3, false);
        CompiereColor.setDefaultBackground(cc);
        CompiereTheme.save(p);
    }

    protected static ColorUIResource parseColor(String info, ColorUIResource stdColor) {
        if (info == null || info.length() == 0) {
            return stdColor;
        }
        try {
            int r = Integer.parseInt(info.substring(info.indexOf("r=") + 2, info.indexOf(",g=")));
            int g = Integer.parseInt(info.substring(info.indexOf("g=") + 2, info.indexOf(",b=")));
            int b = 0;
            int a = 255;
            if (info.indexOf("a=") == -1) {
                b = Integer.parseInt(info.substring(info.indexOf("b=") + 2, info.indexOf("]")));
            } else {
                b = Integer.parseInt(info.substring(info.indexOf("b=") + 2, info.indexOf(",a=")));
                a = Integer.parseInt(info.substring(info.indexOf("a=") + 2, info.indexOf("]")));
            }
            ColorUIResource retValue = new ColorUIResource(new Color(r, g, b, a));
            return retValue;
        }
        catch (Exception e) {
            System.err.println("ParseColor=" + info + " - cannot parse - " + e.toString());
            return stdColor;
        }
    }

    private static FontUIResource parseFont(String info, FontUIResource stdFont) {
        if (info == null) {
            return stdFont;
        }
        try {
            String name = info.substring(info.indexOf("name=") + 5, info.indexOf(",style="));
            String s = info.substring(info.indexOf("style=") + 6, info.indexOf(",size="));
            int style = 0;
            if (s.equals("bold")) {
                style = 1;
            } else if (s.equals("italic")) {
                style = 2;
            } else if (s.equals("bolditalic")) {
                style = 3;
            }
            int size = Integer.parseInt(info.substring(info.indexOf(",size=") + 6, info.lastIndexOf("]")));
            FontUIResource retValue = new FontUIResource(name, style, size);
            return retValue;
        }
        catch (Exception e) {
            System.err.println("ParseFont=" + info + " - cannot parse - " + e.toString());
            return stdFont;
        }
    }

    static {
        NAME = NAME;
        primary0 = new ColorUIResource(51, 51, 102);
        FONT_DEFAULT = FONT_DEFAULT;
        FONT_SIZE = 12;
        CompiereTheme.setDefault();
        P_Primary1 = P_Primary1;
        P_Primary2 = P_Primary2;
        P_Primary3 = P_Primary3;
        P_Secondary1 = P_Secondary1;
        P_Secondary2 = P_Secondary2;
        P_Secondary3 = P_Secondary3;
        P_Black = P_Black;
        P_White = P_White;
        P_Error = P_Error;
        P_Info = P_Info;
        P_Mandatory = P_Mandatory;
        P_Inactive = P_Inactive;
        P_Txt_OK = P_Txt_OK;
        P_Txt_Error = P_Txt_Error;
        P_Control = P_Control;
        P_System = P_System;
        P_User = P_User;
        P_Small = P_Small;
        P_Window = P_Window;
        P_Menu = P_Menu;
        P_CompiereColor = P_CompiereColor;
    }
}

