/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.groupchat;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.RootPaneContainer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import nu.fw.jeti.events.JETIListener;
import nu.fw.jeti.events.StatusChangeListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.IQPrivate;
import nu.fw.jeti.jabber.elements.IQXExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.plugins.groupchat.GroupchatSignin;
import nu.fw.jeti.plugins.groupchat.Plugin;
import nu.fw.jeti.plugins.groupchat.elements.Conference;
import nu.fw.jeti.plugins.groupchat.elements.PrivateBookmarkExtension;
import nu.fw.jeti.plugins.groupchat.handlers.PrivateBookmarkHandler;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.TableSorter;
import nu.fw.jeti.util.Utils;

public class Bookmarks
implements StatusChangeListener {
    private Backend backend;
    private JMenu groupchatMenu;
    private List urls;
    private List conferences;
    private ConferencesTableModel conferencesTableModel = new ConferencesTableModel();
    private JButton delButton;
    private static String[] columnNames = new String[]{I18N.gettext((String)"groupchat.Room"), I18N.gettext((String)"groupchat.Auto_open")};

    public Bookmarks(Backend backend, JMenu jMenu) {
        this.backend = backend;
        this.groupchatMenu = jMenu;
        backend.addExtensionHandler("storage:bookmarks", (ExtensionHandler)new PrivateBookmarkHandler(this));
        backend.addListener(StatusChangeListener.class, (JETIListener)this);
    }

    private void manageBookmarks() {
        if (this.conferences == null || this.conferences.isEmpty()) {
            return;
        }
        final JDialog jDialog = new JDialog((Frame)this.backend.getMainFrame(), I18N.gettext((String)"groupchat.Manage_Bookmarks"));
        Container container = jDialog.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        JLabel jLabel = new JLabel(I18N.gettext((String)"groupchat.bookmarks"));
        jLabel.setAlignmentX(0.5f);
        container.add(jLabel);
        final TableSorter tableSorter = new TableSorter((TableModel)this.conferencesTableModel);
        final JTable jTable = new JTable((TableModel)tableSorter);
        tableSorter.setTableHeader(jTable.getTableHeader());
        tableSorter.setSortingStatus(0, 1);
        jTable.setAlignmentX(0.5f);
        jTable.setPreferredScrollableViewportSize(new Dimension(200, 100));
        jTable.setSelectionMode(0);
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                Bookmarks.this.delButton.setEnabled(!listSelectionModel.isSelectionEmpty());
            }
        });
        JList<Object> jList = new JList<Object>(this.conferences.toArray());
        jList.setAlignmentX(0.5f);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        container.add(jScrollPane);
        this.delButton = new JButton(I18N.gettext((String)"groupchat.delete_bookmark"));
        this.delButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = tableSorter.modelIndex(jTable.getSelectedRow());
                if (n != -1) {
                    Bookmarks.this.conferences.remove(n);
                    Bookmarks.this.conferencesTableModel.update();
                    Bookmarks.this.storeConferences();
                    jDialog.dispose();
                }
            }
        });
        this.delButton.setEnabled(false);
        container.add(this.delButton);
        this.delButton.setAlignmentX(0.5f);
        JButton jButton = new JButton();
        AbstractAction abstractAction = new AbstractAction(I18N.gettext((String)"Close")){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        };
        jButton.setAction(abstractAction);
        jButton.setAlignmentX(0.5f);
        container.add(jButton);
        jDialog.pack();
        jDialog.setLocationRelativeTo(this.backend.getMainFrame());
        jDialog.setVisible(true);
    }

    public void newBookmarks(PrivateBookmarkExtension privateBookmarkExtension) {
        this.urls = privateBookmarkExtension.getURLs();
        this.conferences = privateBookmarkExtension.getConferences();
        this.conferencesTableModel.update();
        if (!this.conferences.isEmpty()) {
            this.addBookmarks(true);
        }
    }

    public void addBookmark(final JID jID, final String string) {
        final JDialog jDialog = new JDialog();
        Container container = jDialog.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(new JLabel(I18N.gettext((String)"groupchat.The_name_of_the_bookmark")));
        final JTextField jTextField = new JTextField(jID.getUser());
        container.add(jTextField);
        final JCheckBox jCheckBox = new JCheckBox(I18N.gettext((String)"groupchat.Automatically_start_groupchat_on_startup?"));
        container.add(jCheckBox);
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(I18N.gettext((String)"OK"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string2 = jTextField.getText();
                if (string2.equals("")) {
                    jDialog.dispose();
                    return;
                }
                if (Bookmarks.this.conferences == null) {
                    Bookmarks.this.conferences = new ArrayList(10);
                } else {
                    Iterator iterator = Bookmarks.this.conferences.iterator();
                    while (iterator.hasNext()) {
                        Conference conference = (Conference)((Object)iterator.next());
                        if (!conference.getName().equals(string2)) continue;
                        Bookmarks.this.conferences.remove((Object)conference);
                        break;
                    }
                }
                Bookmarks.this.conferences.add(new Conference(string2, jID, jCheckBox.isSelected(), string, null));
                Bookmarks.this.conferencesTableModel.update();
                Bookmarks.this.storeConferences();
                jDialog.dispose();
            }
        });
        jPanel.add(jButton);
        jDialog.getRootPane().setDefaultButton(jButton);
        jButton = new JButton();
        AbstractAction abstractAction = new AbstractAction(I18N.gettext((String)"Cancel")){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        };
        Utils.addCancelButton((RootPaneContainer)jDialog, (JButton)jButton, (Action)abstractAction);
        jPanel.add(jButton);
        container.add(jPanel);
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(true);
    }

    private void addBookmarks(boolean bl) {
        this.groupchatMenu.removeAll();
        JMenuItem jMenuItem = new JMenuItem();
        I18N.setTextAndMnemonic((String)"groupchat.Join/Create", (AbstractButton)jMenuItem, (boolean)true);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new GroupchatSignin(Bookmarks.this.backend).setVisible(true);
            }
        });
        this.groupchatMenu.add(jMenuItem);
        if (!this.conferences.isEmpty()) {
            jMenuItem = new JMenuItem();
            I18N.setTextAndMnemonic((String)"groupchat.Manage_Bookmarks", (AbstractButton)jMenuItem, (boolean)true);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Bookmarks.this.manageBookmarks();
                }
            });
            this.groupchatMenu.add(jMenuItem);
        }
        this.groupchatMenu.addSeparator();
        Iterator iterator = this.conferences.iterator();
        while (iterator.hasNext()) {
            Conference conference = (Conference)((Object)iterator.next());
            JID jID = conference.getJid();
            String string = conference.getNick();
            if (string == null) {
                string = this.backend.getMyJID().getUser();
            }
            final JID jID2 = new JID(jID.getUser(), jID.getDomain(), string);
            if (conference.autoJoins() && bl) {
                this.startGroupchat(jID2);
            }
            jMenuItem = new JMenuItem(conference.getName());
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Bookmarks.this.startGroupchat(jID2);
                }
            });
            this.groupchatMenu.add(jMenuItem);
        }
    }

    private void startGroupchat(JID jID) {
        Plugin.startGroupchat(jID, this.backend);
    }

    private void storeConferences() {
        this.backend.send((Packet)new InfoQuery("set", (IQExtension)new IQPrivate((IQXExtension)new PrivateBookmarkExtension(this.urls, this.conferences))));
        this.addBookmarks(false);
    }

    public void exit() {
    }

    public void connectionChanged(boolean bl) {
        if (bl) {
            this.backend.send((Packet)new InfoQuery("get", (IQExtension)new IQPrivate((IQXExtension)new PrivateBookmarkExtension())));
        }
    }

    public void ownPresenceChanged(int n, String string) {
    }

    private class ConferencesTableModel
    extends AbstractTableModel {
        private ConferencesTableModel() {
        }

        public String getColumnName(int n) {
            return columnNames[n];
        }

        public int getRowCount() {
            return Bookmarks.this.conferences.size();
        }

        public int getColumnCount() {
            return columnNames.length;
        }

        public Object getValueAt(int n, int n2) {
            Conference conference = (Conference)((Object)Bookmarks.this.conferences.get(n));
            switch (n2) {
                case 0: {
                    return conference.getName();
                }
                case 1: {
                    return conference.autoJoins();
                }
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public void setValueAt(Object object, int n, int n2) {
            Conference conference = (Conference)((Object)Bookmarks.this.conferences.get(n));
            switch (n2) {
                case 0: {
                    conference.setName((String)object);
                    break;
                }
                case 1: {
                    conference.setAutoJoins((Boolean)object);
                }
            }
            Bookmarks.this.storeConferences();
        }

        void update() {
            this.fireTableDataChanged();
        }
    }
}

