/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.ichatavatars;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import nu.fw.jeti.backend.Connect;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.backend.roster.SecondaryJIDStatus;
import nu.fw.jeti.events.IQResultListener;
import nu.fw.jeti.events.JETIListener;
import nu.fw.jeti.events.PresenceListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.jabber.elements.PresenceBuilder;
import nu.fw.jeti.jabber.elements.XExtension;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.plugins.Avatars;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.ichatavatars.AvatarUpdate;
import nu.fw.jeti.plugins.ichatavatars.AvatarUpdateHandler;
import nu.fw.jeti.plugins.vcard.VCard;
import nu.fw.jeti.util.Base64;
import nu.fw.jeti.util.Log;
import nu.fw.jeti.util.Utils;

public class Plugin
implements Plugins,
Avatars,
PresenceListener {
    public static final String VERSION = "0.1";
    public static final String DESCRIPTION = "ichatavatars.shows_avatars";
    public static final String MIN_JETI_VERSION = "0.6.6";
    public static final String NAME = "ichatavatars";
    public static final String ABOUT = "by E.S. de Boer";
    private static Plugin plugin;
    private HashMap avatars = new HashMap();
    private Backend backend;
    private JIDStatus toolTipJIDStatus;
    private ImageToolTip toolTip = new ImageToolTip();
    private String myAvatarHash;
    private Connect connect;

    public Plugin(Backend backend) {
        File file = new File(Start.path + "avatars" + File.separator);
        if (!file.exists()) {
            file.mkdir();
        }
        this.backend = backend;
        backend.addExtensionHandler("vcard-temp:x:update", (ExtensionHandler)new AvatarUpdateHandler());
        backend.addListener(PresenceListener.class, (JETIListener)this);
    }

    public static void init(Backend backend) {
        plugin = new Plugin(backend);
    }

    public static Object getInstance() {
        return plugin;
    }

    public static void unload(Backend backend) {
        backend.removeExtensionHandler("vcard-temp:x:update");
        plugin = null;
    }

    public void update(Presence presence, SecondaryJIDStatus secondaryJIDStatus) {
        Iterator iterator = presence.getExtensions();
        while (iterator.hasNext()) {
            Extension extension = (Extension)iterator.next();
            if (!(extension instanceof AvatarUpdate)) continue;
            this.update((AvatarUpdate)extension, secondaryJIDStatus);
        }
    }

    public void update(AvatarUpdate avatarUpdate, final SecondaryJIDStatus secondaryJIDStatus) {
        String string;
        if (avatarUpdate.getNick() != null && !avatarUpdate.getNick().equals("")) {
            secondaryJIDStatus.setMSNNick(avatarUpdate.getNick());
        }
        if ((string = avatarUpdate.getHash()) == null) {
            return;
        }
        if (this.avatars.containsKey(string)) {
            secondaryJIDStatus.setAvatar((ImageIcon)this.avatars.get(string));
        } else {
            File file = new File(Start.path + "avatars" + File.separator + string);
            if (file.exists()) {
                ImageIcon imageIcon = new ImageIcon(file.getAbsolutePath());
                this.avatars.put(string, imageIcon);
                secondaryJIDStatus.setAvatar(imageIcon);
            } else {
                this.backend.send(new InfoQuery(secondaryJIDStatus.getJID(), "get", (IQExtension)new VCard()), new IQResultListener(){

                    public void iqResult(InfoQuery infoQuery) {
                        IQExtension iQExtension = infoQuery.getIQExtension();
                        if (iQExtension instanceof VCard) {
                            Plugin.this.decode(((VCard)iQExtension).getPhoto(), string, secondaryJIDStatus);
                        }
                    }
                }, 100);
            }
        }
    }

    public Extension addHash() {
        return new AvatarUpdate(this.myAvatarHash);
    }

    public Presence addHash(JID jID, int n, String string) {
        return new Presence(jID, n, string, (XExtension)new AvatarUpdate(this.myAvatarHash));
    }

    public Presence addHash(JID jID, int n, String string, XExtension xExtension) {
        PresenceBuilder presenceBuilder = new PresenceBuilder();
        presenceBuilder.to = jID;
        presenceBuilder.show = n;
        presenceBuilder.status = string;
        presenceBuilder.addExtension((Extension)xExtension);
        presenceBuilder.addExtension((Extension)new AvatarUpdate(this.myAvatarHash));
        Presence presence = null;
        try {
            presence = (Presence)presenceBuilder.build();
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return presence;
    }

    private void decode(String string, String string2, SecondaryJIDStatus secondaryJIDStatus) {
        if (string == null || string.equals("")) {
            return;
        }
        byte[] byArray = Base64.decode((String)string);
        ImageIcon imageIcon = null;
        try {
            imageIcon = new ImageIcon(byArray);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            return;
        }
        secondaryJIDStatus.setAvatar(imageIcon);
        String string3 = this.hash(byArray);
        if (!string2.equals(string3)) {
            System.out.println(string3);
            System.out.println(string2);
            Log.notParsedXML((String)("Wrong hash of avatar image from" + secondaryJIDStatus.getNick()));
        }
        this.avatars.put(string2, imageIcon);
        this.save(string2, byArray);
    }

    private void save(String string, byte[] byArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(Start.path + "avatars" + File.separator + string);
            ((OutputStream)fileOutputStream).write(byArray);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void updateAvatar(byte[] byArray) {
        this.myAvatarHash = this.hash(byArray);
    }

    public String hash(byte[] byArray) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (Exception exception) {
            System.err.println("no SHA");
            return null;
        }
        return Utils.toString((byte[])messageDigest.digest(byArray));
    }

    public void sendPresence() {
        if (this.connect != null) {
            this.connect.sendStatus();
        }
    }

    public void getVCard(Connect connect) {
        this.connect = connect;
        this.backend.send(new InfoQuery("get", (IQExtension)new VCard()), new IQResultListener(){

            public void iqResult(InfoQuery infoQuery) {
                IQExtension iQExtension = infoQuery.getIQExtension();
                if (iQExtension instanceof VCard) {
                    String string = ((VCard)iQExtension).getPhoto();
                    if (string == null || string.equals("")) {
                        return;
                    }
                    byte[] byArray = Base64.decode((String)string);
                    Plugin.this.updateAvatar(byArray);
                    Plugin.this.sendPresence();
                }
            }
        }, 100);
    }

    public void unload() {
        this.backend.removeListener(PresenceListener.class, (JETIListener)this);
    }

    public void presenceChanged(Presence presence) {
        if (!this.backend.getMyJID().equals(presence.getFrom())) {
            return;
        }
        AvatarUpdate avatarUpdate = null;
        if (presence.hasExtensions()) {
            Iterator iterator = presence.getExtensions();
            while (iterator.hasNext()) {
                Extension extension = (Extension)iterator.next();
                if (!(extension instanceof AvatarUpdate)) continue;
                avatarUpdate = (AvatarUpdate)extension;
            }
        }
        if (avatarUpdate == null) {
            this.myAvatarHash = null;
        } else if (avatarUpdate.getHash() != null && !avatarUpdate.getHash().equals(this.myAvatarHash)) {
            this.myAvatarHash = null;
            this.sendPresence();
            this.getVCard(this.connect);
        }
    }

    public void setToolTipJIDStatus(JIDStatus jIDStatus) {
        this.toolTipJIDStatus = jIDStatus;
    }

    public JToolTip createToolTip() {
        return this.toolTip;
    }

    public class ImageToolTip
    extends JToolTip {
        private ImageIcon icon;
        private JLabel label;
        private JLabel lblIcon;

        public ImageToolTip() {
            this.setLayout(new BorderLayout());
            this.label = new JLabel();
            this.label.setOpaque(true);
            this.label.setBackground(UIManager.getColor("ToolTip.background"));
            this.add((Component)this.label, "Center");
            this.lblIcon = new JLabel();
            this.lblIcon.setOpaque(true);
            this.lblIcon.setBackground(UIManager.getColor("ToolTip.background"));
            this.add((Component)this.lblIcon, "West");
            this.label.setFont(super.getFont());
        }

        public void setTipText(String string) {
            this.label.setText(string);
            if (Plugin.this.toolTipJIDStatus != null) {
                this.icon = Plugin.this.toolTipJIDStatus.getAvatar();
                this.lblIcon.setIcon(this.icon);
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = this.label.getPreferredSize();
            if (this.icon == null) {
                return new Dimension(dimension.width + 2, dimension.height);
            }
            int n = this.icon.getIconHeight();
            if (dimension.getHeight() > (double)n) {
                n = (int)dimension.getHeight();
            }
            return new Dimension(this.icon.getIconWidth() + (int)dimension.getWidth() + 2, n);
        }
    }
}

