/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.titleflash;

import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JFrame;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.plugins.NativeUtils;
import nu.fw.jeti.plugins.Notifiers;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.PluginsInfo;

public class Plugin
implements Plugins,
Notifiers {
    public static final String VERSION = "0.1";
    public static final String DESCRIPTION = "titleflash.Flashes_the_titlebar_when_a_message_arrives";
    public static final String MIN_JETI_VERSION = "0.5.3";
    public static final String NAME = "titleflash";
    public static final String ABOUT = "by E.S. de Boer";
    public static final String PARENT = "Notifiers";
    private static NativeUtils util;
    private Flash flash;
    private Thread flasher;

    public static void init(Backend backend) {
    }

    public static void unload(Backend backend) {
        util = null;
    }

    public void unload() {
        if (this.flash != null) {
            this.flash.stop();
        }
        this.flasher = null;
    }

    private void loadWindowsUtils() throws InstantiationException {
        if (util == null) {
            if (PluginsInfo.isPluginLoaded((String)"windowsutils")) {
                util = (NativeUtils)PluginsInfo.newPluginInstance((String)"windowsutils");
            }
            if (util == null) {
                throw new InstantiationException("Windowsutils native code not loaded");
            }
        }
    }

    public void init(JFrame jFrame, String string) {
        if (this.flash == null) {
            try {
                this.loadWindowsUtils();
            }
            catch (InstantiationException instantiationException) {
                System.out.println("Titleflash: " + instantiationException.getMessage());
                return;
            }
            this.flash = new Flash(jFrame);
        } else {
            this.flash.setFrame(jFrame);
        }
        jFrame.addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent windowEvent) {
                if (Plugin.this.flash != null) {
                    Plugin.this.flash.stop();
                }
                Plugin.this.flasher = null;
            }

            public void windowLostFocus(WindowEvent windowEvent) {
            }
        });
    }

    public void setTitle(String string) {
    }

    public void start(String string) {
        if (this.flasher == null && util != null) {
            this.flash.start();
            this.flasher = new Thread(this.flash);
            this.flasher.start();
        }
    }

    public void stop() {
    }

    static class Flash
    implements Runnable {
        private int intratime = 1000;
        private int intertime = 100;
        private JFrame frame;
        private volatile boolean flash = true;

        public Flash(JFrame jFrame) {
            this.frame = jFrame;
        }

        public void setFrame(JFrame jFrame) {
            this.frame = jFrame;
        }

        public synchronized boolean start() {
            if (this.frame.isFocused()) {
                return false;
            }
            this.flash = true;
            return true;
        }

        public synchronized void stop() {
            this.flash = false;
            this.notifyAll();
        }

        public void run() {
            try {
                while (this.flash) {
                    util.flash((Component)this.frame, true);
                    Thread.sleep(this.intratime);
                    util.flash((Component)this.frame, false);
                    Thread.sleep(this.intertime);
                }
                util.flash((Component)this.frame, false);
            }
            catch (Exception exception) {
                System.out.println("Titleflash: " + exception.getMessage());
            }
        }
    }
}

