/*
 * Decompiled with CFR 0.152.
 */
package mil.jfcom.cie.media.srtp.packetizer;

import mil.jfcom.cie.media.srtp.packetizer.KissFFT;

public class MDFEchoCanceller {
    private static final float MIN_LEAK = 0.001f;
    private int adapted;
    private final float betaMax;
    private final float beta0;
    private int cancelCount;
    private float[] d;
    private float[] e;
    private float[] eE;
    private float[] eeh;
    private KissFFT fftTable;
    private final int frameSize;
    private float[] lastY;
    private final int mm;
    private float memX;
    private float memD;
    private float memE;
    private final float[] notchMem = new float[2];
    private final float notchRadius;
    private float pey;
    private float[] phi;
    private float[] power;
    private final float preemph;
    private float pyy;
    private float[] rf;
    private final int samplingRate;
    private final float specAverage;
    private float sumAdapt;
    private float[] wW;
    private float[] window;
    private final int windowSize;
    private float[] wtmp;
    private float[] x;
    private float[] xX;
    private float[] xxf;
    private float[] y;
    private float[] yY;
    private float[] yf;
    private float[] yh;
    private float[] yps;
    private float[] power1;

    private static void filterDcNotch16(float[] in, float radius, float[] out, int len, float[] mem) {
        float den2 = radius * radius + 0.7f * (1.0f - radius) * (1.0f - radius);
        for (int i = 0; i < len; ++i) {
            float vin = in[i];
            float vout = mem[0] + vin;
            mem[0] = mem[1] + 2.0f * (-vin + radius * vout);
            mem[1] = vin - den2 * vout;
            out[i] = radius * vout;
        }
    }

    private static float innerProd(float[] x, int len) {
        int index = len;
        float sum = 0.0f;
        int i = len;
        while (i-- > 0) {
            sum += x[index] * x[index];
            ++index;
        }
        return sum;
    }

    private static void powerSpectrum(float[] x, int iX, float[] ps, int nN) {
        ps[0] = x[iX] * x[iX];
        int i = 1;
        int j = 1;
        while (i < nN - 1) {
            int iXi = iX + i;
            int iXi1 = iXi + 1;
            ps[j] = x[iXi] * x[iXi] + x[iXi1] * x[iXi1];
            i += 2;
            ++j;
        }
        ps[j] = x[iX + i] * x[iX + i];
    }

    private static void spectralMulAccum(float[] x, float[] y, float[] acc, int n, int m) {
        int i;
        for (i = 0; i < n; ++i) {
            acc[i] = 0.0f;
        }
        int iX = 0;
        int iY = 0;
        for (int j = 0; j < m; ++j) {
            acc[0] = acc[0] + x[iX] * y[iY];
            for (i = 1; i < n - 1; i += 2) {
                int iXi = iX + i;
                int iXi1 = iXi + 1;
                int iYi = iY + i;
                int iYi1 = iYi + 1;
                int n2 = i;
                acc[n2] = acc[n2] + (x[iXi] * y[iYi] - x[iXi1] * y[iYi1]);
                int n3 = i + 1;
                acc[n3] = acc[n3] + (x[iXi1] * y[iYi] + x[iXi] * y[iYi1]);
            }
            int n4 = i;
            acc[n4] = acc[n4] + x[iX + i] * y[iY + i];
            iX += n;
            iY += n;
        }
    }

    private static void weightedSpectralMulConj(float[] w, float[] X, int iX, float[] Y, float[] prod, int iprod, int N) {
        prod[iprod] = w[0] * X[iX] * Y[0];
        int i = 1;
        int j = 1;
        while (i < N - 1) {
            int iXi = iX + i;
            int iXi1 = iXi + 1;
            int i1 = i + 1;
            prod[iprod + i] = w[j] * (X[iXi] * Y[i] + X[iXi1] * Y[i1]);
            prod[iprod + i1] = w[j] * (-X[iXi1] * Y[i] + X[iXi] * Y[i1]);
            i += 2;
            ++j;
        }
        prod[iprod + i] = w[j] * X[iX + i] * Y[i];
    }

    public MDFEchoCanceller(int fsize, int filterLength) {
        int i;
        this.frameSize = fsize;
        int nn = this.windowSize = 2 * this.frameSize;
        this.mm = (filterLength + this.frameSize - 1) / this.frameSize;
        this.cancelCount = 0;
        this.sumAdapt = 0.0f;
        this.samplingRate = 8000;
        this.specAverage = this.frameSize / this.samplingRate;
        this.beta0 = 2.0f * (float)this.frameSize / (float)this.samplingRate;
        this.betaMax = 0.5f * (float)this.frameSize / (float)this.samplingRate;
        this.fftTable = new KissFFT(nn);
        this.e = new float[nn];
        this.x = new float[nn];
        this.d = new float[nn];
        this.y = new float[nn];
        this.yps = new float[nn];
        this.lastY = new float[nn];
        int frameSize1 = this.frameSize + 1;
        this.yf = new float[frameSize1];
        this.rf = new float[frameSize1];
        this.xxf = new float[frameSize1];
        this.yh = new float[frameSize1];
        this.eeh = new float[frameSize1];
        int mn = this.mm * nn;
        this.xX = new float[mn];
        this.yY = new float[nn];
        this.eE = new float[nn];
        this.wW = new float[mn];
        this.phi = new float[mn];
        this.power = new float[frameSize1];
        this.power1 = new float[frameSize1];
        this.window = new float[nn];
        this.wtmp = new float[nn];
        for (i = 0; i < nn; ++i) {
            this.window[i] = 0.5f - 0.5f * (float)Math.cos((float)Math.PI * 2 * (float)i / (float)nn);
        }
        for (i = 0; i < nn * this.mm; ++i) {
            this.wW[i] = 0.0f;
            this.phi[i] = 0.0f;
        }
        this.memX = 0.0f;
        this.memD = 0.0f;
        this.memE = 0.0f;
        this.preemph = 0.9f;
        this.notchRadius = this.samplingRate < 12000 ? 0.9f : (this.samplingRate < 24000 ? 0.982f : 0.992f);
        this.notchMem[0] = 0.0f;
        this.notchMem[1] = 0.0f;
        this.adapted = 0;
        this.pey = 1.0f;
        this.pyy = 1.0f;
    }

    public void speexEchoCancel(float[] ref, short[] echo, int echoOffset, float[] out, int[] yout) {
        float rer;
        float leakEstimate;
        int j;
        int i = 0;
        float pey2 = 1.0f;
        float pyy2 = 1.0f;
        int nN = this.windowSize;
        float ss = 0.35f / (float)this.mm;
        float ss1 = 1.0f - ss;
        float m1 = 1.0f / (float)this.mm;
        ++this.cancelCount;
        MDFEchoCanceller.filterDcNotch16(ref, this.notchRadius, this.d, this.frameSize, this.notchMem);
        int ei = echoOffset;
        while (i < this.frameSize) {
            int i2 = i + this.frameSize;
            this.x[i] = this.x[i2];
            this.x[i2] = (float)echo[ei] - this.preemph * this.memX;
            this.memX = echo[ei];
            float tmp = this.d[i];
            this.d[i] = this.d[i2];
            this.d[i2] = tmp - this.preemph * this.memD;
            this.memD = tmp;
            ++i;
            ++ei;
        }
        for (i = 0; i < nN * (this.mm - 1); ++i) {
            this.xX[i] = this.xX[i + nN];
        }
        this.fftTable.spxFFT(this.x, this.xX, (this.mm - 1) * nN);
        MDFEchoCanceller.spectralMulAccum(this.xX, this.wW, this.yY, nN, this.mm);
        this.fftTable.spxIFFT(this.yY, 0, this.y);
        MDFEchoCanceller.spectralMulAccum(this.xX, this.phi, this.yY, nN, this.mm);
        this.fftTable.spxIFFT(this.yY, 0, this.e);
        for (i = 0; i < this.frameSize; ++i) {
            int iw = i + this.frameSize;
            float yy = this.window[iw] * this.e[iw] + this.window[i] * this.y[iw];
            float tmpOut = this.d[iw] - yy;
            if (tmpOut > 32767.0f) {
                tmpOut = 32767.0f;
            } else if (tmpOut < -32768.0f) {
                tmpOut = -32768.0f;
            }
            out[i] = tmpOut > 32767.0f ? 32767.0f : (tmpOut < -32768.0f ? -32768.0f : (float)((short)(tmpOut += this.preemph * this.memE)));
            this.memE = tmpOut;
        }
        for (i = 0; i < this.frameSize; ++i) {
            this.e[i] = 0.0f;
            int iw = i + this.frameSize;
            this.e[iw] = this.d[iw] - this.y[iw];
        }
        float see = MDFEchoCanceller.innerProd(this.e, this.frameSize);
        see += 10000.0f;
        float syy = MDFEchoCanceller.innerProd(this.y, this.frameSize);
        this.fftTable.spxFFT(this.e, this.eE, 0);
        for (i = 0; i < this.frameSize; ++i) {
            this.y[i] = 0.0f;
        }
        this.fftTable.spxFFT(this.y, this.yY, 0);
        MDFEchoCanceller.powerSpectrum(this.eE, 0, this.rf, nN);
        MDFEchoCanceller.powerSpectrum(this.yY, 0, this.yf, nN);
        MDFEchoCanceller.powerSpectrum(this.xX, (this.mm - 1) * nN, this.xxf, nN);
        for (j = 0; j <= this.frameSize; ++j) {
            this.power[j] = ss1 * this.power[j] + 1.0f + ss * this.xxf[j];
        }
        for (j = this.frameSize; j >= 0; --j) {
            float eh2 = this.rf[j] - this.eeh[j];
            float yh2 = this.yf[j] - this.yh[j];
            pey2 += eh2 * yh2;
            pyy2 += yh2 * yh2;
            this.eeh[j] = (1.0f - this.specAverage) * this.eeh[j] + this.specAverage * this.rf[j];
            this.yh[j] = (1.0f - this.specAverage) * this.yh[j] + this.specAverage * this.yf[j];
        }
        float tmp32 = this.beta0 * syy;
        float tmpf = this.betaMax * see;
        if (tmp32 > tmpf) {
            tmp32 = tmpf;
        }
        float alpha = tmp32 / see;
        float alpha1 = 1.0f - alpha;
        this.pey = alpha1 * this.pey + alpha * pey2;
        this.pyy = alpha1 * this.pyy + alpha * pyy2;
        if (this.pyy < 1.0f) {
            this.pyy = 1.0f;
        }
        if (this.pey < (tmpf = 0.001f * this.pyy)) {
            this.pey = tmpf;
        }
        if (this.pey > this.pyy) {
            this.pey = this.pyy;
        }
        if ((leakEstimate = this.pey / this.pyy) > 16383.0f) {
            leakEstimate = 32767.0f;
        }
        if ((rer = 3.0f * leakEstimate * syy / see) > 0.5f) {
            rer = 0.5f;
        }
        if (this.adapted == 0 && this.sumAdapt > 1.0f) {
            this.adapted = 1;
        }
        if (this.adapted != 0) {
            for (i = 0; i <= this.frameSize; ++i) {
                float r = leakEstimate * this.yf[i];
                float e1 = this.rf[i] + 1.0f;
                tmpf = 0.5f * e1;
                if (r > tmpf) {
                    r = tmpf;
                }
                r = 0.8f * r + 0.2f * rer * e1;
                this.power1[i] = m1 * r / (e1 * (this.power[i] + 10.0f));
            }
        } else {
            float adaptRate = 0.0f;
            float sxx = MDFEchoCanceller.innerProd(this.x, this.frameSize);
            tmp32 = 0.15f * sxx;
            tmpf = 0.25f * see;
            if (sxx > tmpf) {
                sxx = tmpf;
            }
            adaptRate = m1 * sxx / see;
            for (i = 0; i <= this.frameSize; ++i) {
                this.power1[i] = adaptRate / (this.power[i] + 10.0f);
            }
            this.sumAdapt += adaptRate;
        }
        for (j = 0; j < this.mm; ++j) {
            MDFEchoCanceller.weightedSpectralMulConj(this.power1, this.xX, j * nN, this.eE, this.phi, nN * j, nN);
        }
        for (i = 0; i < this.mm * nN; ++i) {
            int n = i;
            this.wW[n] = this.wW[n] + this.phi[i];
            this.phi[i] = this.wW[i] - this.phi[i];
        }
        for (j = 0; j < this.mm; ++j) {
            if (j != this.mm - 1 && this.cancelCount % (this.mm - 1) != j) continue;
            this.fftTable.spxIFFT(this.wW, j * nN, this.wtmp);
            for (i = this.frameSize; i < nN; ++i) {
                this.wtmp[i] = 0.0f;
            }
            this.fftTable.spxFFT(this.wtmp, this.wW, j * nN);
        }
        if (yout != null) {
            if (this.adapted != 0) {
                for (i = 0; i < this.frameSize; ++i) {
                    this.lastY[i] = this.lastY[this.frameSize + i];
                }
                for (i = 0; i < this.frameSize; ++i) {
                    this.lastY[this.frameSize + i] = ref[i] - out[i];
                }
            } else {
                for (i = 0; i < nN; ++i) {
                    this.lastY[i] = this.x[i];
                }
            }
            for (i = 0; i < nN; ++i) {
                this.y[i] = this.window[i] * this.lastY[i];
            }
            this.fftTable.spxFFT(this.y, this.yY, 0);
            MDFEchoCanceller.powerSpectrum(this.yY, 0, this.yps, nN);
            float leak2 = (double)leakEstimate > 0.5 ? 1.0f : 2.0f * leakEstimate;
            for (i = 0; i <= this.frameSize; ++i) {
                yout[i] = (int)(leak2 * this.yps[i]);
            }
        }
    }
}

