/*
 * Decompiled with CFR 0.152.
 */
package mil.jfcom.cie.media.srtp.data;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyManagementException;
import mil.jfcom.cie.media.srtp.Logging;
import mil.jfcom.cie.media.srtp.SRTPUtil;
import mil.jfcom.cie.media.srtp.data.SRTPStream;

public class SRTPReceiveStream
extends SRTPStream {
    private static final int INDEX_RANGE = 65536;
    private static final int INDEX_RANGE_MIDDLE = 32768;
    private long replayMask;
    private int sl;

    public SRTPReceiveStream(Key ke, Key ka, byte[] ks, int ntag, byte[] firstPacket) throws GeneralSecurityException {
        super(ke, ka, ks, ntag);
        this.sl = (firstPacket[2] & 0xFF) << 8 | firstPacket[3] & 0xFF;
    }

    public int process(byte[] srtpPacket, int inOffset, int length, byte[] outputRTP, int outOffset) throws GeneralSecurityException {
        int v;
        if (this.packetsUsingMasterKey >= 0xFFFFFFFFFFFFL) {
            throw new KeyManagementException("Master key's max SRTP packet number of 2^48 has been exceeded.");
        }
        byte[] restoreROC = null;
        int posSEQ = inOffset + 2;
        int seq = (srtpPacket[posSEQ] & 0xFF) << 8 | srtpPacket[posSEQ + 1] & 0xFF;
        int delta = seq - this.sl;
        if (this.sl < 32768) {
            if (delta > 32768) {
                v = -1;
                delta -= 65536;
            } else {
                v = 0;
            }
        } else if (delta + 32768 < 0) {
            v = 1;
            int newROC = SRTPUtil.bytes2int(this.roc, 0) + 1;
            restoreROC = this.roc;
            this.roc = new byte[4];
            SRTPUtil.int2bytes(newROC, this.roc, 0);
            delta += 65536;
        } else {
            v = 0;
        }
        int posSSRC = inOffset + 8;
        byte[] iv = new byte[]{0, 0, 0, 0, srtpPacket[posSSRC++], srtpPacket[posSSRC++], srtpPacket[posSSRC++], srtpPacket[posSSRC], this.roc[0], this.roc[1], this.roc[2], this.roc[3], srtpPacket[posSEQ], srtpPacket[posSEQ + 1], 0, 0};
        if (v < 0) {
            int rocMinus1 = SRTPUtil.bytes2int(this.roc, 0) - 1;
            SRTPUtil.int2bytes(rocMinus1, iv, 8);
        }
        int rtpLength = length - this.ntag;
        this.mac.update(srtpPacket, inOffset, rtpLength);
        this.mac.update(iv, 8, 4);
        byte[] tag = this.mac.doFinal();
        int i = 0;
        int j = rtpLength + inOffset;
        while (i < this.ntag) {
            if (tag[i] != srtpPacket[j]) {
                if (restoreROC != null) {
                    this.roc = restoreROC;
                }
                throw new GeneralSecurityException("SRTP packet failed message authentication");
            }
            ++i;
            ++j;
        }
        boolean isReplay = false;
        if (delta > 0) {
            this.replayMask <<= delta;
            this.replayMask |= 1L;
            this.sl = seq;
        } else if (delta < -63) {
            isReplay = true;
        } else {
            long bit = 1L << -delta;
            if ((this.replayMask & bit) != 0L) {
                isReplay = true;
            } else {
                this.replayMask |= bit;
                if (delta < 0) {
                    Logging.LOG.info((Object)("RTP packet out of order: " + seq + " after " + this.sl));
                }
            }
        }
        if (isReplay) {
            throw new GeneralSecurityException("Ignore replay SRTP packet, seq: " + Integer.toHexString(seq));
        }
        ++this.packetsUsingMasterKey;
        SRTPUtil.xor(this.ks, iv, 0, this.ns, iv, 0);
        int hdrSize = 12 + (srtpPacket[inOffset] & 0xF) * 4;
        int encyptLen = rtpLength - hdrSize;
        SRTPUtil.runCipher(this.cipher, iv, srtpPacket, hdrSize + inOffset, encyptLen, outputRTP, hdrSize + outOffset);
        System.arraycopy(srtpPacket, inOffset, outputRTP, outOffset, hdrSize);
        return rtpLength;
    }
}

