/*
 * Decompiled with CFR 0.152.
 */
package mil.jfcom.cie.media.srtp.control;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyManagementException;
import mil.jfcom.cie.media.srtp.SRTPUtil;
import mil.jfcom.cie.media.srtp.control.SRTCPStream;

public class SRTCPReceiveStream
extends SRTCPStream {
    private static final int EBIT_INDEX_BYTES = 4;
    private int lastIndex;
    private long replayMask;

    public SRTCPReceiveStream(Key ke, Key ka, byte[] ks, int ntag) throws GeneralSecurityException {
        super(ke, ka, ks, ntag);
    }

    public int process(byte[] srtcpPacket, int inOffset, int length, byte[] outputRTCP, int outOffset) throws GeneralSecurityException {
        if (this.packetsUsingMasterKey >= Integer.MAX_VALUE) {
            throw new KeyManagementException("Master key's max SRTP packet number of 2^48 has been exceeded.");
        }
        int authLength = length - this.ntag - inOffset;
        this.mac.update(srtcpPacket, inOffset, authLength);
        byte[] tag = this.mac.doFinal();
        int i = 0;
        int j = authLength + inOffset;
        while (i < this.ntag) {
            if (tag[i] != srtcpPacket[j]) {
                throw new GeneralSecurityException("SRTCP packet failed message authentication");
            }
            ++i;
            ++j;
        }
        int rtcpLength = authLength - 4;
        int indexPos = rtcpLength + inOffset;
        boolean isReplay = false;
        int packetIndex = SRTPUtil.bytes2int(srtcpPacket, indexPos) & Integer.MAX_VALUE;
        int delta = packetIndex - this.lastIndex;
        if (delta > 0) {
            this.lastIndex = packetIndex;
            this.replayMask <<= delta;
            this.replayMask |= 1L;
        } else if (delta < -63) {
            isReplay = true;
        } else {
            long bit = 1L << -delta;
            if ((this.replayMask & bit) != 0L) {
                isReplay = true;
            } else {
                this.replayMask |= bit;
            }
        }
        if (isReplay) {
            throw new GeneralSecurityException("Ignore replay SRTCP packet, seq: " + Integer.toHexString(packetIndex));
        }
        ++this.packetsUsingMasterKey;
        if (srtcpPacket[indexPos] < 0) {
            int posSSRC = inOffset + 4;
            byte[] iv = new byte[]{0, 0, 0, 0, srtcpPacket[posSSRC++], srtcpPacket[posSSRC++], srtcpPacket[posSSRC++], srtcpPacket[posSSRC], 0, 0, (byte)(srtcpPacket[indexPos++] & 0x7F), srtcpPacket[indexPos++], srtcpPacket[indexPos++], srtcpPacket[indexPos], 0, 0};
            SRTPUtil.xor(this.ks, iv, 0, this.ns, iv, 0);
            SRTPUtil.runCipher(this.cipher, iv, srtcpPacket, 8 + inOffset, rtcpLength - 8, outputRTCP, 8 + outOffset);
        }
        System.arraycopy(srtcpPacket, inOffset, outputRTCP, outOffset, 8);
        return rtcpLength;
    }
}

